/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Region;
import com.atlassian.aws.HttpClientConfigurationUtilsDoNotUse;
import com.atlassian.aws.s3.BambooAmazonS3Client;
import com.atlassian.aws.s3.S3Support;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.Nullable;

public class AmazonClients {
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final Logger log = Logger.getLogger(AmazonClients.class);
    private static final AtomicBoolean logRegionOnce = new AtomicBoolean();
    private static AtomicReference<com.amazonaws.regions.Region> currentRegion = null;

    private AmazonClients() {
    }

    public static BambooAmazonS3Client newAmazonS3Client(AWSCredentials awsCredentials) {
        ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration(DEFAULT_TRANSMISSION_TIMEOUT_MS, 5);
        BambooAmazonS3Client amazonS3Client = new BambooAmazonS3Client(awsCredentials, clientConfiguration);
        com.amazonaws.regions.Region currentRegion = AmazonClients.getCurrentRegion();
        if (currentRegion != null) {
            Level level = logRegionOnce.compareAndSet(false, true) ? Level.INFO : Level.DEBUG;
            log.log((Priority)level, (Object)("Detected current region " + currentRegion + ", using it for S3 access"));
            amazonS3Client.setRegion(currentRegion);
        }
        return amazonS3Client;
    }

    @Nullable
    private static synchronized com.amazonaws.regions.Region getCurrentRegion() {
        if (currentRegion == null) {
            currentRegion = new AtomicReference<com.amazonaws.regions.Region>(Regions.getCurrentRegion());
        }
        return currentRegion.get();
    }

    public static void setBestEndpointForBucket(AmazonS3 s3Client, String bucket) {
        log.info((Object)("Detecting bucket location for [" + bucket + "] via " + s3Client.getRegion().toAWSRegion()));
        String bucketLocation = AmazonClients.getBucketLocation(s3Client, bucket);
        if (bucketLocation == null) {
            return;
        }
        try {
            Region region = Region.fromValue((String)bucketLocation);
            com.amazonaws.regions.Region awsRegion = region.toAWSRegion();
            Region oldregion = s3Client.getRegion();
            s3Client.setRegion(awsRegion);
            if (AmazonClients.getBucketLocation(s3Client, bucket) != null) {
                log.info((Object)("S3 endpoint for " + bucket + " set to: " + S3Support.getEndpoint(awsRegion)));
            } else {
                log.info((Object)("S3 endpoint for " + bucket + " left at: " + S3Support.getEndpoint(awsRegion)));
                s3Client.setRegion(oldregion.toAWSRegion());
            }
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Unable to get bucket location, using default.", (Throwable)e);
        }
    }

    @Nullable
    private static String getBucketLocation(AmazonS3 s3Client, String bucketName) {
        try {
            return s3Client.getBucketLocation(bucketName);
        }
        catch (AmazonClientException e) {
            log.warn((Object)("Unable to get bucket location for [" + bucketName + "], using default. Error: " + (Object)((Object)e)));
            log.debug((Object)"", (Throwable)e);
            return null;
        }
    }
}

