/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.s3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

public class S3UtilsThin {
    @NotNull
    public static String calculateEtag(@NotNull File file, long chunkingThreshold, long chunkSize) throws IOException {
        MessageDigest md5digest;
        try {
            md5digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        int digests = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), md5digest);){
            long toRead;
            boolean shouldUseMultipartUpload = file.length() > chunkingThreshold;
            long l = toRead = shouldUseMultipartUpload ? chunkSize : Long.MAX_VALUE;
            while (S3UtilsThin.skip(digestInputStream, toRead) == toRead) {
                baos.write(md5digest.digest());
                md5digest.reset();
                ++digests;
            }
            baos.write(md5digest.digest());
        }
        if (++digests == 1) {
            return Hex.encodeHexString((byte[])baos.toByteArray());
        }
        return DigestUtils.md5Hex((byte[])baos.toByteArray()) + "-" + digests;
    }

    private static long skip(InputStream input, long toSkip) throws IOException {
        long remainingToRead;
        int numRead;
        int bufSize = 4096;
        byte[] buf = new byte[4096];
        for (remainingToRead = toSkip; remainingToRead > 0L && (numRead = input.read(buf, 0, (int)Math.min(remainingToRead, 4096L))) != -1; remainingToRead -= (long)numRead) {
        }
        return toSkip - remainingToRead;
    }
}

