/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Base64;

public class JsonUtils {
    static final String KEY_STORE_PASSWORD = "bamboo";
    private static final ObjectMapper mapper;

    public static <T> T fromJson(String json, Class<T> classOfT) throws IOException {
        return (T)mapper.readValue(json, classOfT);
    }

    public static String toJson(Object userData) {
        try {
            return mapper.writeValueAsString(userData);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SimpleModule keyStoreModule = new SimpleModule().addSerializer(KeyStore.class, (JsonSerializer)new KeyStoreSerialiser()).addDeserializer(KeyStore.class, (JsonDeserializer)new KeyStoreDeserialiser());
        mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)keyStoreModule);
    }

    private static class KeyStoreSerialiser
    extends JsonSerializer<KeyStore> {
        private KeyStoreSerialiser() {
        }

        public void serialize(KeyStore keyStore, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                keyStore.store(byteArrayOutputStream, JsonUtils.KEY_STORE_PASSWORD.toCharArray());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            String keyStoreContents = Base64.getMimeEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            jsonGenerator.writeStartArray();
            jsonGenerator.writeString(keyStore.getType());
            jsonGenerator.writeString(keyStoreContents);
            jsonGenerator.writeEndArray();
        }
    }

    private static class KeyStoreDeserialiser
    extends JsonDeserializer<KeyStore> {
        private KeyStoreDeserialiser() {
        }

        public KeyStore deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY) {
                throw new JsonParseException("Start array expected", jsonParser.getCurrentLocation());
            }
            try {
                String keyStoreType = jsonParser.nextTextValue();
                String keyStoreContent = jsonParser.nextTextValue();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                byte[] decoded = Base64.getMimeDecoder().decode(keyStoreContent);
                keyStore.load(new ByteArrayInputStream(decoded), JsonUtils.KEY_STORE_PASSWORD.toCharArray());
                return keyStore;
            }
            catch (Exception e) {
                throw new JsonParseException("Could not deserialize keystore", jsonParser.getCurrentLocation(), (Throwable)e);
            }
        }
    }
}

