/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy;

import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallableFile;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy.AbstractInstallStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipInstallStrategy
extends AbstractInstallStrategy {
    public UnzipInstallStrategy(String homeDir) {
        super(homeDir);
    }

    @Override
    public void install(InstallableFile file) throws IOException {
        byte[] buffer = new byte[0x400000];
        File destination = this.getDestFile(file);
        destination.mkdirs();
        InputStream sourceStream = this.getResourceAsStream(file.getSrc());
        System.out.println("Unzipping " + file.getSrc() + " to " + String.valueOf(destination));
        if (sourceStream != null) {
            try (ZipInputStream zipInputStream = new ZipInputStream(sourceStream);){
                ZipEntry entry;
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    File destinationFile = new File(destination, entry.getName());
                    if (entry.isDirectory()) {
                        System.out.println("Creating directory " + entry.getName() + "'");
                        destinationFile.mkdirs();
                        continue;
                    }
                    System.out.println("Extracting '" + entry.getName() + "'");
                    destinationFile.getParentFile().mkdirs();
                    destinationFile.delete();
                    destinationFile.createNewFile();
                    try (FileOutputStream outputStream = new FileOutputStream(destinationFile);){
                        int bytesRead;
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                        }
                    }
                }
            }
        } else {
            System.err.println("Could not find source file " + file.getSrc());
        }
    }
}

