/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared.utils;

public class PlatformUtils {
    private static final String DATA_MODEL = PlatformUtils.getDataModel();
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");

    public static boolean isUnix() {
        return !PlatformUtils.isWindows();
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isOsX() {
        return OS_NAME.toLowerCase().startsWith("mac os x");
    }

    public static boolean isSolaris() {
        return OS_NAME.toLowerCase().startsWith("sunos");
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().contains("window");
    }

    public static boolean isX86() {
        return OS_ARCH.matches("(i\\d86)|(ia\\d\\d)|(amd64)") || OS_ARCH.contains("x86");
    }

    public static boolean isArm() {
        return OS_ARCH.toLowerCase().contains("aarch64") || OS_ARCH.toLowerCase().contains("arm64");
    }

    public static boolean isSparc() {
        return OS_ARCH.toLowerCase().contains("sparc");
    }

    public static boolean is64bitArch() {
        return "64".equals(DATA_MODEL);
    }

    private static String getDataModel() {
        String dataModel = System.getProperty("sun.arch.data.model");
        if (dataModel == null && (dataModel = System.getProperty("com.ibm.vm.bitmode")) == null) {
            dataModel = "32";
        }
        return dataModel;
    }
}

