/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared;

import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallStrategy;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallableFile;
import com.atlassian.bamboo.agent.bootstrap.shared.utils.JavaServiceWrapperFileNames;
import com.atlassian.bamboo.agent.bootstrap.shared.utils.PlatformUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WrapperInstaller {
    public static final String WRAPPER_CONF = "wrapper.conf";
    public static final String WRAPPER_LICENSE_CONF = "wrapper-license.conf";

    public static List<InstallableFile> getWrapperFilesToInstall(InstallStrategy fileInstallStrategy) {
        JavaServiceWrapperFileNames fileNames;
        if (PlatformUtils.isLinux()) {
            fileNames = WrapperInstaller.getFilesToInstallForLinux();
        } else if (PlatformUtils.isOsX()) {
            fileNames = JavaServiceWrapperFileNames.createOsXFileNames();
        } else if (PlatformUtils.isSolaris()) {
            fileNames = WrapperInstaller.getFilesToInstallForSolaris();
        } else if (PlatformUtils.isWindows()) {
            fileNames = WrapperInstaller.getFilesToInstallForWindows();
        } else {
            WrapperInstaller.unsupportedPlatform("Unknown OS: " + PlatformUtils.OS_NAME);
            fileNames = null;
        }
        if (fileNames != null) {
            ArrayList<InstallableFile> results = new ArrayList<InstallableFile>();
            results.add(new InstallableFile("/generic/conf/wrapper-license.conf", "conf/wrapper-license.conf", fileInstallStrategy));
            results.add(new InstallableFile("/generic/lib/wrapper.jar", "lib/wrapper.jar", fileInstallStrategy));
            InstallableFile executableFile = new InstallableFile(fileNames.getExecutableSrcPath(), fileNames.getExecutableDstPath(), fileInstallStrategy, true);
            results.add(executableFile);
            InstallableFile libraryFile = new InstallableFile(fileNames.getLibrarySrcPath(), fileNames.getLibraryDstPath(), fileInstallStrategy);
            results.add(libraryFile);
            List<InstallableFile> scriptFiles = WrapperInstaller.getWrapperScripts(fileInstallStrategy);
            results.addAll(scriptFiles);
            return results;
        }
        return Collections.emptyList();
    }

    private static JavaServiceWrapperFileNames getFilesToInstallForLinux() {
        String archSubdir;
        if (PlatformUtils.isX86()) {
            archSubdir = PlatformUtils.is64bitArch() ? "linux/x86_64" : "linux/x86";
        } else {
            WrapperInstaller.unsupportedPlatform("Unknown architecture: " + PlatformUtils.OS_ARCH);
            return null;
        }
        return JavaServiceWrapperFileNames.createUnixFileNames(archSubdir);
    }

    private static JavaServiceWrapperFileNames getFilesToInstallForSolaris() {
        String archSubdir;
        if (PlatformUtils.isX86()) {
            archSubdir = PlatformUtils.is64bitArch() ? "solaris/x86_64" : "solaris/x86";
        } else if (PlatformUtils.isSparc()) {
            archSubdir = PlatformUtils.is64bitArch() ? "solaris/sparc_64" : "solaris/sparc";
        } else {
            WrapperInstaller.unsupportedPlatform("Unknown architecture: " + PlatformUtils.OS_ARCH);
            return null;
        }
        return JavaServiceWrapperFileNames.createUnixFileNames(archSubdir);
    }

    private static JavaServiceWrapperFileNames getFilesToInstallForWindows() {
        String archSubdir = PlatformUtils.is64bitArch() ? "windows/64" : "windows/32";
        return JavaServiceWrapperFileNames.createWindowsFileNames(archSubdir);
    }

    private static List<InstallableFile> getWrapperScripts(InstallStrategy fileInstallStrategy) {
        ArrayList<InstallableFile> installableFiles = new ArrayList<InstallableFile>();
        if (PlatformUtils.isUnix()) {
            InstallableFile scriptFile = new InstallableFile("/generic/bin/bamboo-agent.sh", "bin/bamboo-agent.sh", fileInstallStrategy, true);
            installableFiles.add(scriptFile);
        } else {
            installableFiles.add(new InstallableFile("/generic/bin/BambooAgent.bat", "bin/BambooAgent.bat", fileInstallStrategy));
            installableFiles.add(new InstallableFile("/generic/bin/InstallBambooAgent-NT.bat", "bin/InstallBambooAgent-NT.bat", fileInstallStrategy));
            installableFiles.add(new InstallableFile("/generic/bin/StartBambooAgent-NT.bat", "bin/StartBambooAgent-NT.bat", fileInstallStrategy));
            installableFiles.add(new InstallableFile("/generic/bin/StopBambooAgent-NT.bat", "bin/StopBambooAgent-NT.bat", fileInstallStrategy));
            installableFiles.add(new InstallableFile("/generic/bin/UninstallBambooAgent-NT.bat", "bin/UninstallBambooAgent-NT.bat", fileInstallStrategy));
        }
        return installableFiles;
    }

    private static void unsupportedPlatform(String message) {
        System.err.println("WARNING: " + message);
        System.err.println("Bamboo agent will run in fail fast mode.  If the Bamboo server goes down,");
        System.err.println("the agent will need to be restarted.");
    }
}

