/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared.utils;

import java.io.File;

public class JavaServiceWrapperFileNames {
    private static final String EXECUTABLE_PATH = "bin";
    private static final String LIBRARY_PATH = "lib";
    private final String libraryName;
    private final String executableName;
    private final String archDir;

    private JavaServiceWrapperFileNames(String executableName, String libraryName, String archSubDir) {
        this.executableName = executableName;
        this.libraryName = libraryName;
        this.archDir = "/arch/" + archSubDir;
    }

    public static JavaServiceWrapperFileNames createUnixFileNames(String archSubDir) {
        return new JavaServiceWrapperFileNames("wrapper", "libwrapper.so", archSubDir);
    }

    public static JavaServiceWrapperFileNames createOsXFileNames() {
        return new JavaServiceWrapperFileNames("wrapper", "libwrapper.jnilib", "osx");
    }

    public static JavaServiceWrapperFileNames createWindowsFileNames(String archSubDir) {
        return new JavaServiceWrapperFileNames("wrapper.exe", "wrapper.dll", archSubDir);
    }

    public String getExecutableSrcPath() {
        return this.archDir + "/" + this.executableName;
    }

    public String getLibrarySrcPath() {
        return this.archDir + "/" + this.libraryName;
    }

    public String getExecutableDstPath() {
        return EXECUTABLE_PATH + File.separator + this.executableName;
    }

    public String getLibraryDstPath() {
        return LIBRARY_PATH + File.separator + this.libraryName;
    }
}

