/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy;

import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallableFile;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy.AbstractInstallStrategy;
import com.atlassian.bamboo.agent.bootstrap.shared.utils.PlatformUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CopyStrategy
extends AbstractInstallStrategy {
    public CopyStrategy(String homeDir) {
        super(homeDir);
    }

    @Override
    public void install(InstallableFile file) throws IOException {
        this.copyFile(file);
    }

    private void copyFile(InstallableFile file) throws IOException {
        File destFile = this.getDestFile(file);
        String fileSource = file.getSrc();
        System.out.println("Installing file: " + file.getSrc() + " to: " + destFile.getPath());
        try (InputStream is = this.getResourceAsStream(fileSource);){
            if (is == null) {
                throw new FileNotFoundException("File not found: " + fileSource);
            }
            try (FileOutputStream os = new FileOutputStream(destFile);){
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = is.read(buffer)) >= 0) {
                    os.write(buffer, 0, bytesRead);
                }
            }
        }
        catch (IOException e) {
            System.err.println("An error occurred while installing file " + file.getSrc());
            throw e;
        }
        this.setExecutable(file);
    }

    private void setExecutable(InstallableFile file) throws IOException {
        if (file.isExecutable() && PlatformUtils.isUnix()) {
            try {
                File destFile = this.getDestFile(file);
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec(new String[]{"chmod", "+x", destFile.getAbsolutePath()});
                }
                catch (IOException e) {
                    System.err.println("Error invoking chmod commandString");
                    throw e;
                }
                StringBuilder sb = new StringBuilder();
                BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = processOutput.readLine();
                while (line != null) {
                    sb.append(line).append(System.getProperty("line.separator"));
                    line = processOutput.readLine();
                }
                processOutput.close();
                int rc = process.waitFor();
                if (rc != 0) {
                    String errorMsg = "chmod on " + destFile.getAbsolutePath() + " terminated with non zero return code: " + rc;
                    System.err.println(sb.toString());
                    System.err.println(errorMsg);
                    throw new IOException(errorMsg);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

