/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy;

import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallableFile;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy.AbstractInstallStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpandTemplateStrategy
extends AbstractInstallStrategy {
    private static final Pattern SCRIPT_TEMPLATE_SUBSTITUTION = Pattern.compile("%(\\w+)%");
    private final Map<String, String> environment;

    public ExpandTemplateStrategy(String homeDir, Map<String, String> environment) {
        super(homeDir);
        this.environment = environment;
    }

    @Override
    public void install(InstallableFile file) throws IOException {
        File destFile = this.getDestFile(file);
        System.out.println("Installing file: " + destFile.getPath());
        String fileSource = file.getSrc();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getResourceAsStream(fileSource)));
             BufferedWriter out = new BufferedWriter(new FileWriter(destFile));){
            String line;
            while ((line = in.readLine()) != null) {
                String substitutedLine = line;
                Matcher m = SCRIPT_TEMPLATE_SUBSTITUTION.matcher(line);
                while (m.find()) {
                    String substituteVariable = m.group(1);
                    String substituteValue = m.group(0);
                    if (this.environment.containsKey(substituteVariable)) {
                        substituteValue = this.environment.get(substituteVariable).replaceAll("\\\\", "\\\\\\\\");
                    }
                    substitutedLine = substitutedLine.replaceFirst(m.group(0), substituteValue);
                }
                out.write(substitutedLine);
                out.newLine();
            }
        }
        catch (IOException e) {
            System.err.println("Error occurred installing file " + file.getDest());
            throw e;
        }
    }
}

