/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy;

import com.atlassian.bamboo.agent.bootstrap.shared.installation.InstallableFile;
import com.atlassian.bamboo.agent.bootstrap.shared.installation.strategy.AbstractInstallStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipInstallStrategy
extends AbstractInstallStrategy {
    public UnzipInstallStrategy(String homeDir) {
        super(homeDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void install(InstallableFile file) throws IOException {
        byte[] buffer = new byte[0x400000];
        File destination = this.getDestFile(file);
        destination.mkdirs();
        InputStream sourceStream = this.getResourceAsStream(file.getSrc());
        System.out.println("Unzipping " + file.getSrc() + " to " + destination);
        if (sourceStream == null) {
            System.err.println("Could not find source file " + file.getSrc());
            return;
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(sourceStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                FileOutputStream outputStream;
                block25: {
                    File destinationFile = new File(destination, entry.getName());
                    if (entry.isDirectory()) {
                        System.out.println("Creating directory " + entry.getName() + "'");
                        destinationFile.mkdirs();
                        continue;
                    }
                    System.out.println("Extracting '" + entry.getName() + "'");
                    destinationFile.getParentFile().mkdirs();
                    destinationFile.delete();
                    destinationFile.createNewFile();
                    outputStream = new FileOutputStream(destinationFile);
                    Throwable throwable = null;
                    try {
                        int bytesRead;
                        while ((bytesRead = zipInputStream.read(buffer)) != -1) {
                            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                        }
                        if (outputStream == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (outputStream == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputStream).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)outputStream).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)outputStream).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)outputStream).close();
            }
            return;
        }
    }
}

