/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AccessTokenPermission {
    READ(1, Collections.emptyList()),
    TRIGGER(2, Collections.singletonList(READ)),
    USER(4, Collections.singletonList(TRIGGER));

    private final int mask;
    private final List<AccessTokenPermission> dependencies;

    private AccessTokenPermission(int mask, List<AccessTokenPermission> dependencies) {
        this.mask = mask;
        this.dependencies = Collections.unmodifiableList(dependencies);
    }

    @Nullable
    public static AccessTokenPermission forName(@NotNull String name) {
        try {
            return AccessTokenPermission.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getMask() {
        return this.mask;
    }

    public List<AccessTokenPermission> getDependencies() {
        return this.dependencies;
    }
}

