/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import com.atlassian.bamboo.utils.ByteSource;
import io.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.zip.Adler32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class JarDescriptor {
    private final String name;
    private final ByteSource inputSupplier;
    private final Supplier<Long> checksum = new LazyReference<Long>(){
        private static final int STREAM_BUFFER_LENGTH = 4096;

        protected Long create() throws Exception {
            try (InputStream data = JarDescriptor.this.getInputStream();){
                Adler32 checksum = new Adler32();
                byte[] buffer = new byte[4096];
                int read = data.read(buffer, 0, 4096);
                while (read > -1) {
                    checksum.update(buffer, 0, read);
                    read = data.read(buffer, 0, 4096);
                }
                Long l = checksum.getValue();
                return l;
            }
        }
    };
    private final Optional<File> file;

    public JarDescriptor(String name, ByteSource inputSupplier) {
        this(null, name, inputSupplier);
    }

    public JarDescriptor(@NotNull File file, ByteSource inputSupplier) {
        this(file, file.getName(), inputSupplier);
    }

    public JarDescriptor(@Nullable File file, String name, ByteSource inputSupplier) {
        this.name = name;
        this.inputSupplier = inputSupplier;
        this.file = Optional.ofNullable(file);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public long getChecksum() {
        return this.checksum.get();
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return this.inputSupplier.openStream();
    }

    @NotNull
    public FileHashDescriptor getFileHashDescriptor() {
        return new FileHashDescriptor(this.getName(), this.getChecksum());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarDescriptor that = (JarDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.checksum, that.checksum) && Objects.equals(this.file, this.file);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }

    public Optional<Long> getLength() {
        return this.file.map(File::length);
    }

    public Optional<Long> getLastModified() {
        return this.file.map(File::lastModified);
    }
}

