/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.Instance;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.credentials.AWSCredentials;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.InstanceLaunchConfigurationBuilder;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstanceListener;
import com.atlassian.bamboo.agent.elastic.tunnel.ElasticAgentTunnelPorts;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.ElasticTunnelDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.collection.multimap.SetMultimap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ElasticInstanceManager
extends ElasticAgentTunnelPorts {
    public static final EC2InstanceType DEFAULT_INSTANCE_TYPE_32 = EC2InstanceType.C1_MEDIUM;
    public static final EC2InstanceType DEFAULT_INSTANCE_TYPE_64 = EC2InstanceType.M5Large;
    public static final String DEFAULT_PRODUCT_FOR_LINUX_PLATFORM = "Linux/UNIX";
    public static final String DEFAULT_PRODUCT_FOR_WINDOWS_PLATFORM = "Windows";
    public static final String ELASTIC_BAMBOO_SECURITY_GROUP;
    public static final String ELASTIC_BAMBOO_KEY_PAIR;
    public static final String ELASTIC_BAMBOO_KEY_PAIR_FILE;

    public RemoteElasticInstance newElasticAgent(RemoteElasticInstanceListener var1, AWSAccount var2, AgentManager var3, ElasticImageConfiguration var4, InstanceLaunchConfigurationBuilder var5) throws NoSuchAlgorithmException, KeyManagementException, IOException, CertificateException, UnrecoverableKeyException, KeyStoreException;

    public RemoteElasticInstance restoreElasticAgent(@NotNull ElasticAgentDefinition var1, @Nullable ElasticTunnelDefinition var2, @NotNull Instance var3, @NotNull RemoteElasticInstanceListener var4, @NotNull AWSAccount var5, @NotNull AgentManager var6, @NotNull InstanceLaunchConfigurationBuilder var7) throws Exception;

    public void ensureLoginKeyPairExists(AWSAccount var1, String var2) throws AWSException;

    public boolean validateAwsCredentials(AwsSupportConstants.Region var1, AWSCredentials var2, ErrorCollection var3);

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgents();

    @NotNull
    public List<RemoteElasticInstance> getRequestedElasticRemoteAgents();

    @NotNull
    public List<RemoteElasticInstance> getStartingElasticInstances();

    public List<RemoteElasticInstance> getAllElasticRemoteAgents();

    @NotNull
    public List<RemoteElasticInstance> getInstancesWithStartingAgents();

    public SetMultimap<ElasticImageConfiguration, RemoteElasticInstance> getAllElasticAgentsAsMap();

    public int getTotalNumElasticRemoteAgents();

    @Nullable
    public RemoteElasticInstance getElasticRemoteAgentByInstanceId(String var1);

    public void registerElasticAgentStopped(@NotNull RemoteElasticInstance var1);

    public void onInstanceIdentified(@NotNull RemoteElasticInstance var1);

    public void onInstanceRunning(@NotNull RemoteElasticInstance var1);

    public void addElasticLogEntry(Logger var1, String var2);

    @Deprecated
    public void addElasticLogEntry(org.apache.log4j.Logger var1, String var2);

    public List<String> getElasticAgentLogs();

    public boolean isElasticSupportEnabled();

    @NotNull
    public Set<EC2InstanceType> getAllowedInstanceTypes();

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgentsByConfiguration(@NotNull ElasticImageConfiguration var1);

    @NotNull
    public List<RemoteElasticInstance> getElasticRemoteAgentsByConfiguration(long var1);

    public boolean cancelSpotRequests(@NotNull AWSAccount var1);

    @NotNull
    public String getInstanceLogs(@NotNull String var1) throws AWSException;

    public boolean isInstanceKnown(@NotNull String var1);

    public String getBambooControlTag();

    static {
        ELASTIC_BAMBOO_KEY_PAIR = ELASTIC_BAMBOO_SECURITY_GROUP = SystemProperty.ELASTIC_BAMBOO_CUSTOM_ENTITY.getValue("elasticbamboo");
        ELASTIC_BAMBOO_KEY_PAIR_FILE = ELASTIC_BAMBOO_KEY_PAIR + ".pk";
    }
}

