/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.ephemeral;

import com.atlassian.bamboo.agent.ephemeral.PodPhase;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;

public interface EphemeralAgentPod {
    @NotNull
    public String getName();

    @NotNull
    public String getHostname();

    @NotNull
    public String getPodIP();

    @NotNull
    public Date getCreationDate();

    @NotNull
    public PodPhase getPhase();

    @NotNull
    public List<EphemeralAgentPodContainer> getContainers();

    public static class EphemeralAgentPodContainer {
        private final String name;
        private final String image;
        private final boolean started;
        private final boolean ready;
        private final Map<String, String> variables;

        public EphemeralAgentPodContainer(String name, String image, boolean ready, boolean started, Map<String, String> variables) {
            this.name = name;
            this.image = image;
            this.variables = variables;
            this.ready = ready;
            this.started = started;
        }

        public String getImage() {
            return this.image;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isReady() {
            return this.ready;
        }

        public Map<String, String> getVariables() {
            return this.variables;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EphemeralAgentPodContainer)) {
                return false;
            }
            EphemeralAgentPodContainer that = (EphemeralAgentPodContainer)o;
            return this.started == that.started && this.ready == that.ready && Objects.equals(this.name, that.name) && Objects.equals(this.image, that.image) && Objects.equals(this.variables, that.variables);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.image, this.started, this.ready, this.variables);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("image", (Object)this.image).append("started", this.started).append("ready", this.ready).append("variables", this.variables).toString();
        }
    }
}

