/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.ephemeral.result;

import com.atlassian.bamboo.agent.ephemeral.result.AgentMaintenanceResult;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class CommonAgentMaintenanceResult
implements AgentMaintenanceResult {
    protected final String rawOutput;
    protected final String rawErrorOutput;
    private static final String WARNING_CONSTANT = "Warning: ";

    public CommonAgentMaintenanceResult(String rawOutput, String rawErrorOutput) {
        this.rawOutput = rawOutput;
        this.rawErrorOutput = rawErrorOutput;
    }

    @Override
    public String getRawOutput() {
        return this.rawOutput;
    }

    @Override
    public String getRawErrorOutput() {
        return this.rawErrorOutput;
    }

    @Override
    public boolean isSuccessful() {
        return StringUtils.isBlank((CharSequence)this.rawErrorOutput) || Arrays.stream(Optional.ofNullable(this.rawErrorOutput).orElse("").split("\n")).map(String::trim).filter(StringUtils::isNotBlank).allMatch(line -> line.startsWith(WARNING_CONSTANT));
    }
}

