/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.avatar;

import com.atlassian.bamboo.avatar.AvatarSupplier;
import com.atlassian.bamboo.avatar.ResourceAvatarSupplier;
import com.atlassian.bamboo.utils.Validations;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AvatarType {
    USER(1, "users", "image/png"){

        @Override
        @NotNull
        protected String buildPath(@NotNull String id, int size) {
            Objects.requireNonNull(id, "id");
            Validations.checkArgument(DEFAULT_SIZES.contains(size), "Default user avatars are not available in %s px", size);
            return "avatars/user/" + size + ".png";
        }
    };

    static final Set<Integer> DEFAULT_SIZES;
    private final String contentType;
    private final String directoryName;
    private final int id;

    private AvatarType(int id, String directoryName, String mediaType) {
        this.directoryName = Objects.requireNonNull(directoryName, "directoryName");
        this.id = id;
        this.contentType = mediaType;
    }

    public static AvatarType fromId(int id) {
        for (AvatarType value : AvatarType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No AvatarType is available for ID " + id);
    }

    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @NotNull
    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public AvatarSupplier loadDefault(@NotNull String id, int size) {
        return new ResourceAvatarSupplier(this.contentType, this.buildPath(id, size));
    }

    @NotNull
    public AvatarSupplier loadFixedDefault(int size) {
        return this.loadDefault("unknown", size);
    }

    @NotNull
    protected abstract String buildPath(@NotNull String var1, int var2);

    static {
        DEFAULT_SIZES = Set.of(Integer.valueOf(24), Integer.valueOf(32), Integer.valueOf(48), Integer.valueOf(64), Integer.valueOf(96), Integer.valueOf(128), Integer.valueOf(256));
    }
}

