/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.utils.Validations;
import java.io.File;
import java.nio.file.Path;

public class ArtifactRetrievalStatus {
    public static final ArtifactRetrievalStatus UNABLE = new ArtifactRetrievalStatus(null, null, false);
    private final File file;
    private final String artifactLinkType;
    private final boolean isSingleFile;

    private ArtifactRetrievalStatus(File file, String artifactLinkType, boolean isSingleFile) {
        this.file = file;
        this.artifactLinkType = artifactLinkType;
        this.isSingleFile = isSingleFile;
    }

    public static ArtifactRetrievalStatus singleFile(File file, String artifactLinkType) {
        return new ArtifactRetrievalStatus(file, artifactLinkType, true);
    }

    public static ArtifactRetrievalStatus multipleFiles(File dir, String artifactLinkType) {
        return new ArtifactRetrievalStatus(dir, artifactLinkType, false);
    }

    public static ArtifactRetrievalStatus multipleFiles(Path dir, String artifactLinkType) {
        return new ArtifactRetrievalStatus(dir.toFile(), artifactLinkType, false);
    }

    public boolean isRetrieved() {
        return this.file != null;
    }

    public boolean isSingleFile() {
        return this.isSingleFile;
    }

    public void setRetrievalInfo(ArtifactSubscriptionContext artifactSubscription) {
        Validations.checkState(this.isRetrieved(), "Artifact is not retrieved");
        artifactSubscription.setSingleFile(this.isSingleFile());
        artifactSubscription.setEffectiveDestinationPath(this.file.getAbsolutePath());
    }

    public String getLinkType() {
        return this.artifactLinkType;
    }

    public File getSingleFile() {
        Validations.checkState(this.isSingleFile, "Retrieved multiple files, attempted to obtain a single file");
        return this.file;
    }
}

