/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogInterceptorStack
implements LogInterceptor {
    private final List<LogInterceptor> taskLevelInterceptors = new ArrayList<LogInterceptor>();
    private final List<LogInterceptor> interceptors = new ArrayList<LogInterceptor>();

    public synchronized void clear() {
        this.taskLevelInterceptors.clear();
    }

    public synchronized void clearFromJob() {
        this.interceptors.clear();
    }

    public synchronized void add(@NotNull LogInterceptor interceptor) {
        this.taskLevelInterceptors.add(interceptor);
    }

    public synchronized void addForJob(@NotNull LogInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public synchronized void remove(@Nullable LogInterceptor interceptor) {
        this.taskLevelInterceptors.remove(interceptor);
    }

    public synchronized void removeFromJob(@Nullable LogInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    @Override
    public synchronized void intercept(@NotNull LogEntry logEntry) {
        for (LogInterceptor interceptor : this.interceptors) {
            interceptor.intercept(logEntry);
        }
        for (LogInterceptor interceptor : this.taskLevelInterceptors) {
            interceptor.intercept(logEntry);
        }
    }

    @Override
    public synchronized void interceptError(@NotNull LogEntry logEntry) {
        for (LogInterceptor interceptor : this.interceptors) {
            interceptor.interceptError(logEntry);
        }
        for (LogInterceptor interceptor : this.taskLevelInterceptors) {
            interceptor.interceptError(logEntry);
        }
    }

    public synchronized Collection<LogInterceptor> listForJob() {
        return Collections.unmodifiableList(this.interceptors);
    }
}

