/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class BuildHangingConfig
implements Serializable {
    public static final double DEFAULT_MULTIPLIER = 2.5;
    public static final int DEFAULT_LOG_TIME = 20;
    public static final int DEFAULT_QUEUE_TIMEOUT_MINUTES = 5;
    public static final int MINIMUM_LOG_LINE_LENGTH_LIMIT = 100;
    public static final int MINIMUM_LOG_COUNT_LIMIT = 100;
    public static final int MINIMUM_LOG_SIZE_LIMIT = 1;
    public static final int DEFAULT_LOG_LINE_LENGTH_LIMIT = 2048;
    public static final int DEFAULT_LOG_COUNT_LIMIT = 5000;
    public static final int DEFAULT_LOG_SIZE_LIMIT = 1024;
    private double multiplier = 2.5;
    private int minutesBetweenLogs = 20;
    private int minutesBeforeQueueTimeout = 5;
    private boolean disabled = false;
    private boolean liveLogsAreActive = true;
    private boolean enableLogLineLengthLimit;
    private int maxLogLineLength = 2048;
    private boolean enableLogLineCountLimit;
    private int maxLogLineCount = 1024;
    private boolean enableLogSizeLimit;
    private int maxLogSizeKilobytes = 1024;

    public BuildHangingConfig() {
    }

    public BuildHangingConfig(@NotNull BuildHangingConfig buildHangingConfig) {
        this.multiplier = buildHangingConfig.multiplier;
        this.minutesBetweenLogs = buildHangingConfig.minutesBetweenLogs;
        this.minutesBeforeQueueTimeout = buildHangingConfig.minutesBeforeQueueTimeout;
        this.disabled = buildHangingConfig.disabled;
        this.liveLogsAreActive = buildHangingConfig.isLiveLogsAreActive();
        this.maxLogLineCount = buildHangingConfig.getMaxLogLineCount();
        this.maxLogLineLength = buildHangingConfig.getMaxLogLineLength();
        this.maxLogSizeKilobytes = buildHangingConfig.getMaxLogSizeKilobytes();
        this.enableLogLineLengthLimit = buildHangingConfig.enableLogLineLengthLimit;
        this.enableLogLineCountLimit = buildHangingConfig.enableLogLineCountLimit;
        this.enableLogSizeLimit = buildHangingConfig.enableLogSizeLimit;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public int getMinutesBetweenLogs() {
        return this.minutesBetweenLogs;
    }

    public void setMinutesBetweenLogs(int minutesBetweenLogs) {
        this.minutesBetweenLogs = minutesBetweenLogs;
    }

    public int getMinutesBeforeQueueTimeout() {
        return this.minutesBeforeQueueTimeout;
    }

    public void setMinutesBeforeQueueTimeout(int minutesBeforeQueueTimeout) {
        this.minutesBeforeQueueTimeout = minutesBeforeQueueTimeout;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isLiveLogsAreActive() {
        return this.liveLogsAreActive;
    }

    public void setLiveLogsAreActive(boolean liveLogsAreActive) {
        this.liveLogsAreActive = liveLogsAreActive;
    }

    public int getMaxLogLineLength() {
        return this.maxLogLineLength;
    }

    public void setMaxLogLineLength(int maxLogLineLength) {
        this.maxLogLineLength = maxLogLineLength;
    }

    public int getMaxLogLineCount() {
        return this.maxLogLineCount;
    }

    public void setMaxLogLineCount(int maxLogLineCount) {
        this.maxLogLineCount = maxLogLineCount;
    }

    public int getMaxLogSizeKilobytes() {
        return this.maxLogSizeKilobytes;
    }

    public void setMaxLogSizeKilobytes(int maxLogSizeKilobytes) {
        this.maxLogSizeKilobytes = maxLogSizeKilobytes;
    }

    public boolean isEnableLogLineLengthLimit() {
        return this.enableLogLineLengthLimit;
    }

    public void setEnableLogLineLengthLimit(boolean enableLogLineLengthLimit) {
        this.enableLogLineLengthLimit = enableLogLineLengthLimit;
    }

    public boolean isEnableLogLineCountLimit() {
        return this.enableLogLineCountLimit;
    }

    public void setEnableLogLineCountLimit(boolean enableLogLineCountLimit) {
        this.enableLogLineCountLimit = enableLogLineCountLimit;
    }

    public boolean isEnableLogSizeLimit() {
        return this.enableLogSizeLimit;
    }

    public void setEnableLogSizeLimit(boolean enableLogSizeLimit) {
        this.enableLogSizeLimit = enableLogSizeLimit;
    }
}

