/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.pipeline.concurrent;

import com.atlassian.bamboo.security.ImpersonationHelper;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SystemAuthorityThreadFactory
implements ThreadFactory {
    private static final Logger log = Logger.getLogger(SystemAuthorityThreadFactory.class);
    private static final AtomicInteger THREAD_FACTORY_ID = new AtomicInteger();
    private final String threadName;
    private final DefaultThreadFactory threadFactory;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public SystemAuthorityThreadFactory(String threadName) {
        this(threadName, (t, e) -> log.error((Object)("Uncaught exception in thread " + t.getName()), e));
    }

    public SystemAuthorityThreadFactory(String threadName, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.threadName = THREAD_FACTORY_ID.getAndIncrement() + "-" + threadName;
        this.threadFactory = new DefaultThreadFactory();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = this.threadFactory.newThread(ImpersonationHelper.makeRunnableWithSystemAuthority(r));
        return this.setupThread(thread);
    }

    @NotNull
    public <T extends Thread> T newThread(@NotNull Class<T> threadClass, @NotNull Runnable r) {
        T thread = this.threadFactory.newThread(threadClass, ImpersonationHelper.makeRunnableWithSystemAuthority(r));
        return this.setupThread(thread);
    }

    @NotNull
    private <T extends Thread> T setupThread(T thread) {
        thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        if (this.threadName != null) {
            thread.setName(this.threadName + ":" + thread.getName());
        }
        thread.setPriority(1);
        thread.setDaemon(true);
        return thread;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            return this.setupThread(t);
        }

        public <T extends Thread> T newThread(Class<T> threadClass, Runnable r) {
            try {
                Thread t = (Thread)threadClass.getDeclaredConstructor(Runnable.class).newInstance(r);
                return (T)this.setupThread(t);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Thread class cannot be constructed");
            }
        }

        @NotNull
        private <T extends Thread> T setupThread(T t) {
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

