/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.warning;

import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class WarningAnnotation
implements WhitelistedSerializable {
    private final Long repositoryId;
    private final String fileName;
    private final Integer lineNumber;
    private final String message;
    private final Severity severity;
    private final String category;
    private final String source;

    private WarningAnnotation(Long repositoryId, Severity severity, String fileName, Integer lineNumber, String message, String category, String source) {
        this.severity = severity;
        this.repositoryId = repositoryId;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.message = message;
        this.category = category;
        this.source = source;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public static enum Severity {
        LOW,
        NORMAL,
        HIGH;

    }

    public static class Builder {
        private Long repositoryId;
        private String fileName;
        private Integer lineNumber;
        private String message;
        private Severity severity;
        private String category;
        private String source;

        public Builder repositoryId(@Nullable Long repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder fileName(@NotNull String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder lineNumber(@Nullable Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder severity(@NotNull Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public WarningAnnotation build() {
            return new WarningAnnotation(this.repositoryId, this.severity, this.fileName, this.lineNumber, this.message, this.category, this.source);
        }
    }
}

