/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.ephemeral.EphemeralAgentTemplate;
import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.EphemeralAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class AgentAssignmentServiceHelper {
    private AgentAssignmentServiceHelper() {
    }

    public static AgentAssignmentService.AgentAssignmentExecutor asExecutor(AgentAssignment.ExecutorType executorType, long executorId) {
        return new AgentAssignmentService.AgentAssignmentExecutor(executorType, executorId);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(BuildAgent agent, boolean directAssignmentsOnly) {
        return AgentAssignmentServiceHelper.asExecutors(agent.getDefinition(), directAssignmentsOnly);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(BuildAgent agent) {
        return AgentAssignmentServiceHelper.asExecutors(agent.getDefinition());
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(ElasticImageConfiguration elasticImageConfiguration) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.IMAGE, elasticImageConfiguration.getId()));
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(EphemeralAgentTemplate ephemeralAgentTemplate) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.EPHEMERAL, ephemeralAgentTemplate.getId()));
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(PipelineDefinition pipelineDefinition) {
        return AgentAssignmentServiceHelper.asExecutors(pipelineDefinition, false);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(PipelineDefinition pipelineDefinition, final boolean directAssignmentsOnly) {
        final HashSet<AgentAssignmentService.AgentAssignmentExecutor> executors = new HashSet<AgentAssignmentService.AgentAssignmentExecutor>();
        pipelineDefinition.accept(new PipelineDefinitionVisitor(){

            @Override
            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
                if (!directAssignmentsOnly) {
                    executors.add(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.IMAGE, pipelineDefinition.getElasticImageConfigurationId()));
                }
            }

            @Override
            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
            }

            @Override
            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
            }

            @Override
            public void visitEphemeral(EphemeralAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
                if (!directAssignmentsOnly) {
                    executors.add(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.EPHEMERAL, pipelineDefinition.getEphemeralAgentTemplateId()));
                }
            }

            private void visitAgent(PipelineDefinition pipelineDefinition) {
                executors.add(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.AGENT, pipelineDefinition.getId()));
            }
        });
        return executors;
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> asExecutables(@NotNull ImmutableBuildable buildable) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.JOB, buildable.hasMaster() ? buildable.getMaster().getId() : buildable.getId(), buildable.hasMaster() ? buildable.getMaster().getBuildDefinition().getDockerPipelineConfiguration().isEnabled() : buildable.getBuildDefinition().getDockerPipelineConfiguration().isEnabled()));
    }

    public static AgentAssignmentService.AgentAssignmentExecutable asExecutable(@NotNull ImmutableBuildable buildable) {
        return new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.JOB, buildable.hasMaster() ? buildable.getMaster().getId() : buildable.getId(), buildable.hasMaster() ? buildable.getMaster().getBuildDefinition().getDockerPipelineConfiguration().isEnabled() : buildable.getBuildDefinition().getDockerPipelineConfiguration().isEnabled());
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> asExecutables(@NotNull ImmutableBuildable buildable, boolean usesDockerConfiguration) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.JOB, buildable.hasMaster() ? buildable.getMaster().getId() : buildable.getId(), usesDockerConfiguration));
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> asExecutables(@NotNull ImmutablePlan plan) {
        if (plan instanceof ImmutableBuildable) {
            return AgentAssignmentServiceHelper.asExecutables((ImmutableBuildable)plan);
        }
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.PLAN, plan.getId(), false));
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> asExecutables(@NotNull ImmutablePlan plan, boolean usesDockerConfiguration) {
        if (plan instanceof ImmutableBuildable) {
            return AgentAssignmentServiceHelper.asExecutables((ImmutableBuildable)plan, usesDockerConfiguration);
        }
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.PLAN, plan.getId(), usesDockerConfiguration));
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> environmentToExecutables(long environmentId, long deploymentProjectId, boolean usesDockerConfiguration) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.ENVIRONMENT, deploymentProjectId, environmentId, usesDockerConfiguration));
    }

    @Deprecated
    public static AgentAssignmentService.AgentAssignmentExecutable environmentToExecutable(long environmentId) {
        return new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.ENVIRONMENT, environmentId, false);
    }

    @Deprecated
    public static AgentAssignmentService.AgentAssignmentExecutable environmentToExecutable(long environmentId, boolean usesDockerConfiguration) {
        return new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.ENVIRONMENT, environmentId, usesDockerConfiguration);
    }

    @Deprecated
    public static AgentAssignmentService.AgentAssignmentExecutable environmentToExecutable(long environmentId, long deploymentProjectId) {
        return new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.ENVIRONMENT, deploymentProjectId, environmentId, false);
    }

    public static AgentAssignmentService.AgentAssignmentExecutable environmentToExecutable(long environmentId, long deploymentProjectId, boolean usesDockerConfiguration) {
        return new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.ENVIRONMENT, deploymentProjectId, environmentId, usesDockerConfiguration);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> deploymentProjectToExecutables(long deploymentProjectId) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.DEPLOYMENT_PROJECT, deploymentProjectId, false));
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> projectToExecutables(@NotNull Project project) {
        return Collections.singleton(new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.PROJECT, project.getId(), false));
    }

    public static AgentAssignmentService.AgentAssignmentExecutable asExecutable(CommonContext context) {
        AgentAssignment.ExecutableType type = context instanceof BuildContext ? AgentAssignment.ExecutableType.JOB : AgentAssignment.ExecutableType.ENVIRONMENT;
        return new AgentAssignmentService.AgentAssignmentExecutable(type, context.getEntityGroupId(), context.getEntityId(), context.getDockerPipelineConfiguration().isEnabled());
    }
}

