/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.ephemeral.EphemeralAgentPod;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.EphemeralAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.event.AgentConfigurationUpdatedEventFactory;
import com.atlassian.bamboo.license.BambooLicenseException;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AgentManager {
    public static final String DEFAULT_AGENT_NAME = "Default Agent";

    public void createDefaultAgent();

    public void initAgents();

    public void startLocalAgents();

    public void stopLocalAgents() throws InterruptedException;

    @NotNull
    public List<LocalBuildAgent> getAllLocalAgents();

    @NotNull
    public List<BuildAgent> getAllRemoteAgents();

    @NotNull
    public List<BuildAgent> getAllRemoteAgents(boolean var1);

    @NotNull
    public List<ElasticAgentDefinition> getAllElasticAgentDefinitions(int var1, int var2);

    @NotNull
    public List<ElasticAgentDefinition> getOfflineElasticAgentDefinitions(int var1, int var2);

    public long getAgentCount(Class<? extends PipelineDefinition> var1);

    public long getOfflineAgentCount(Class<? extends PipelineDefinition> var1);

    @NotNull
    public List<ElasticAgentDefinition> getAllElasticAgentDefinitions(@NotNull Collection<String> var1);

    @NotNull
    public List<BuildAgent> getOnlineElasticAgents();

    @NotNull
    public List<BuildAgent> getAllAgents();

    @NotNull
    public List<BuildAgent> getAllNonElasticAgents();

    @NotNull
    public List<BuildAgent> getAllStandardAgents();

    @NotNull
    public Collection<BuildAgent> getBusyBuildAgents();

    @NotNull
    public Collection<BuildAgent> getActiveAndEnabledAgents();

    @NotNull
    public Collection<BuildAgent> getRemoteActiveAndEnabledAgents();

    @NotNull
    public Collection<BuildAgent> getElasticActiveAndEnabledAgents();

    @NotNull
    public Collection<LocalBuildAgent> getLocalActiveAndEnabledAgents();

    public void savePipeline(PipelineDefinition var1);

    public void savePipeline(PipelineDefinition var1, @Nullable AgentConfigurationUpdatedEventFactory var2);

    public void saveElasticPipeline(@NotNull ElasticAgentDefinition var1);

    public void saveEphemeralPipeline(@NotNull EphemeralAgentDefinition var1);

    public void saveReturningElasticPipeline(@NotNull ElasticAgentDefinition var1);

    public LocalBuildAgent getLocalAgent(long var1);

    @Nullable
    public BuildAgent getAgent(long var1);

    @Nullable
    public PipelineDefinition getAgentDefinition(@NotNull Long var1);

    @NotNull
    public List<EphemeralAgentPod> getEphemeralAgentPods();

    @NotNull
    public List<EphemeralAgentPod> getEventuallyConsistentEphemeralAgentPods();

    public int getPendingEphemeralAgentsEstimatedCount();

    @NotNull
    public Optional<BuildAgent> getEphemeralAgentByPodName(@NotNull String var1);

    public void stopEphemeralAgentByPodName(@NotNull String var1);

    public Map<Long, PipelineDefinition> findAllAgentsForAgentIds(@NotNull Collection<Long> var1);

    public void disableAllAgents();

    public void enableAllAgents();

    public boolean checkPipelinesAreDisabled();

    public void createLocalAgent(LocalAgentDefinition var1) throws BambooLicenseException;

    public void removeAgent(long var1) throws TimeoutException;

    public void removeRemoteAgent(long var1);

    public void removeEphemeralAgent(long var1);

    public boolean allowNewRemoteAgent();

    public boolean allowNewRemoteAgentWithId(long var1);

    public boolean allowNewRemoteAgents(int var1);

    public boolean allowNewElasticAgent();

    public boolean allowNewElasticAgentWithId(long var1);

    public boolean allowNewEphemeralAgent();

    public boolean allowNewEphemeralAgentWithId(long var1);

    public boolean allowNewElasticAgents(int var1);

    public boolean allowNewLocalAgent();

    public void stopAgent(@NotNull BuildAgent var1);

    public void onAgentReturning(@NotNull BuildAgent var1);

    public List<PipelineDefinition> getAllPersistedAgentDefinitions();

    public void abandonBuild(@NotNull BuildAgent var1, boolean var2);

    @Deprecated
    @Nullable
    public PipelineDefinition getAgentDefinitionByName(@NotNull String var1);

    @NotNull
    public List<PipelineDefinition> getAgentDefinitionsByName(@NotNull String var1);

    @NotNull
    public List<PipelineDefinition> getAgentDefinitionsWithNameLike(@NotNull String var1);

    public void saveAnyPipeline(@NotNull PipelineDefinition var1);

    public void saveAnyPipeline(@NotNull PipelineDefinition var1, @Nullable AgentConfigurationUpdatedEventFactory var2);

    public boolean updateAgentStatusIfResultReturnPossibleAfterServerRestart(long var1, ResultKey var3, String var4, long var5);

    public Optional<BuildAgent> setAgentEnabled(long var1, boolean var3);
}

