/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ManualEncryptionConfiguration
implements Serializable {
    private static final int DEFAULT_LIMIT = 100;
    public static final TimeUnit DEFAULT_LIMIT_UNIT = TimeUnit.HOURS;
    private final boolean enabled;
    private final int limit;
    private final TimeUnit limitUnit;

    public ManualEncryptionConfiguration() {
        this.enabled = true;
        this.limit = 100;
        this.limitUnit = DEFAULT_LIMIT_UNIT;
    }

    public ManualEncryptionConfiguration(boolean enabled, int limit, TimeUnit limitUnit) {
        this.enabled = enabled;
        this.limit = limit;
        this.limitUnit = limitUnit;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getLimit() {
        return this.limit;
    }

    public TimeUnit getLimitUnit() {
        return this.limitUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualEncryptionConfiguration that = (ManualEncryptionConfiguration)o;
        return this.enabled == that.enabled && this.limit == that.limit && this.limitUnit == that.limitUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.limit, this.limitUnit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ManualEncryptionConfiguration{");
        sb.append("enabled=").append(this.enabled);
        sb.append(", limit=").append(this.limit);
        sb.append(", limitUnit=").append((Object)this.limitUnit);
        sb.append('}');
        return sb.toString();
    }
}

