/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PersonalAccessTokensExpirationConfiguration
implements Serializable {
    private final boolean expirationRequired;
    private final int maxDaysUntilExpiry;
    private static final int DEFAULT_TOKENS_MAX_DAYS_UNTIL_EXPIRY = 30;

    public PersonalAccessTokensExpirationConfiguration() {
        this.expirationRequired = false;
        this.maxDaysUntilExpiry = 30;
    }

    public PersonalAccessTokensExpirationConfiguration(boolean expirationRequired, int maxDaysUntilExpiry) {
        this.expirationRequired = expirationRequired;
        this.maxDaysUntilExpiry = maxDaysUntilExpiry;
    }

    public boolean isExpirationRequired() {
        return this.expirationRequired;
    }

    public int getMaxDaysUntilExpiry() {
        return this.maxDaysUntilExpiry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalAccessTokensExpirationConfiguration that = (PersonalAccessTokensExpirationConfiguration)o;
        return this.expirationRequired == that.expirationRequired && this.maxDaysUntilExpiry == that.maxDaysUntilExpiry;
    }

    public int hashCode() {
        return Objects.hash(this.expirationRequired, this.maxDaysUntilExpiry);
    }

    public String toString() {
        return "PersonalAccessTokensExpirationConfiguration{expirationRequired=" + this.expirationRequired + ", maxDaysUntilExpiry=" + this.maxDaysUntilExpiry + "}";
    }
}

