/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfigResolver;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryType;
import java.io.Serializable;
import java.time.Period;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentExpiryConfig
implements Serializable {
    private static final Logger log = LogManager.getLogger(DeploymentExpiryConfig.class);
    public static final long REMOVE_ALL_LOGS = -1L;
    public static final int MINIMUM_DEPLOYMENTS_TO_KEEP = 2;
    private final boolean expiryEnabled;
    private final EnumSet<DeploymentExpiryType> expiryTypes;
    private final String periodUnit;
    private final int duration;
    private final int deploymentsToKeep;
    private final int anyDeploymentsToKeep;
    private final long maxIgnoredLogSize;
    private String expiryPeriod;

    DeploymentExpiryConfig(boolean expiryEnabled, Iterable<DeploymentExpiryType> expiryTypes, String periodUnit, int duration, int deploymentsToKeep, int anyDeploymentsToKeep, long maxIgnoredLogSize) {
        this.expiryEnabled = expiryEnabled;
        this.expiryTypes = EnumSet.noneOf(DeploymentExpiryType.class);
        expiryTypes.forEach(this.expiryTypes::add);
        this.periodUnit = periodUnit;
        this.duration = duration;
        this.deploymentsToKeep = deploymentsToKeep;
        this.anyDeploymentsToKeep = anyDeploymentsToKeep;
        this.maxIgnoredLogSize = maxIgnoredLogSize;
    }

    public boolean isExpiryEnabled() {
        return this.expiryEnabled;
    }

    @NotNull
    public Set<DeploymentExpiryType> getExpiryTypes() {
        return Set.copyOf(this.expiryTypes);
    }

    public Period getExpiryPeriod() {
        return BuildExpiryConfig.toPeriod(this.duration, this.periodUnit);
    }

    @Nullable
    protected String getPeriodString() {
        return this.expiryPeriod;
    }

    public String getPeriodUnit() {
        return this.periodUnit;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getDeploymentsToKeep() {
        return this.deploymentsToKeep;
    }

    public int getAnyDeploymentsToKeep() {
        return this.anyDeploymentsToKeep;
    }

    public long getMaxIgnoredLogSize() {
        return this.maxIgnoredLogSize;
    }

    public boolean shouldExpireDeploymentResultLogs() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_RESULT_LOG_EXPIRY);
    }

    public boolean shouldExpireDeploymentResults() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_RESULT_EXPIRY);
    }

    public boolean shouldExpireDeploymentVersionArtifacts() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_VERSION_ARTIFACTS_EXPIRY);
    }

    public boolean shouldExpireDeploymentVersions() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_VERSION_EXPIRY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentExpiryConfig that = (DeploymentExpiryConfig)o;
        return Objects.equals(this.expiryEnabled, that.expiryEnabled) && Objects.equals(this.expiryTypes, that.expiryTypes) && Objects.equals(this.periodUnit, that.periodUnit) && this.duration == that.duration && Objects.equals(this.deploymentsToKeep, that.deploymentsToKeep) && Objects.equals(this.anyDeploymentsToKeep, that.anyDeploymentsToKeep) && Objects.equals(this.maxIgnoredLogSize, that.maxIgnoredLogSize);
    }

    public int hashCode() {
        return Objects.hash(this.expiryEnabled, this.expiryTypes, this.periodUnit, this.duration, this.deploymentsToKeep, this.anyDeploymentsToKeep, this.maxIgnoredLogSize);
    }

    public String toString() {
        return "DeploymentExpiryConfig{expiryEnabled=" + this.expiryEnabled + ", expiryTypes=" + String.valueOf(this.expiryTypes) + ", periodUnit=" + this.periodUnit + ", duration=" + this.duration + ", deploymentsToKeep=" + this.deploymentsToKeep + ", anyDeploymentsToKeep=" + this.anyDeploymentsToKeep + ", maxIgnoredLogSize=" + this.maxIgnoredLogSize + "}";
    }

    private Object readResolve() {
        return new DeploymentExpiryConfigResolver().resolve(this);
    }
}

