/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.plan.PlanKeys;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
@PublicApi
public final class PlanKey
implements Comparable<PlanKey>,
Key {
    private final String key;
    private volatile transient boolean validated;

    PlanKey(String key) {
        this.key = key;
        this.getKey();
    }

    @Override
    @NotNull
    public String getKey() {
        if (!this.validated) {
            PlanKeys.assertSafeKey(this.key);
            this.validated = true;
        }
        return this.key;
    }

    @NotNull
    public String getPartialKey() {
        return PlanKeys.SHORT_KEY_FROM_PLAN_KEY.apply(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanKey)) {
            return false;
        }
        PlanKey key = (PlanKey)o;
        return this.key.equals(key.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(PlanKey planKey) {
        return this.key.compareTo(planKey.getKey());
    }

    public String toString() {
        return this.getKey();
    }
}

