/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import com.atlassian.bamboo.utils.Validations;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum BranchTriggeringOption {
    INHERITED("inherited"),
    MANUAL_ONLY("manual"),
    CUSTOM("custom");

    private static final Map<String, BranchTriggeringOption> KEYS_TO_BTO;
    private static final BiMap<BranchTriggeringOption, PlanBranchManagementProperties.TriggeringOption> BTO_TO_SPECS_CONSTANTS;
    private String key;

    private BranchTriggeringOption(String key) {
        this.key = key;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public static BranchTriggeringOption fromKey(@NotNull String key) {
        Validations.checkArgument(KEYS_TO_BTO.containsKey(key), key + " is not BranchTriggeringOption", new Object[0]);
        return KEYS_TO_BTO.get(key);
    }

    @NotNull
    public PlanBranchManagementProperties.TriggeringOption toSpecsConstant() {
        return (PlanBranchManagementProperties.TriggeringOption)BTO_TO_SPECS_CONSTANTS.get((Object)this);
    }

    @NotNull
    public static BranchTriggeringOption fromSpecsConstant(@NotNull PlanBranchManagementProperties.TriggeringOption exportConstant) {
        return (BranchTriggeringOption)((Object)BTO_TO_SPECS_CONSTANTS.inverse().get((Object)exportConstant));
    }

    static {
        KEYS_TO_BTO = ImmutableMap.of((Object)INHERITED.getKey(), (Object)((Object)INHERITED), (Object)MANUAL_ONLY.getKey(), (Object)((Object)MANUAL_ONLY), (Object)CUSTOM.getKey(), (Object)((Object)CUSTOM));
        BTO_TO_SPECS_CONSTANTS = ImmutableBiMap.of((Object)((Object)INHERITED), (Object)PlanBranchManagementProperties.TriggeringOption.INHERITED, (Object)((Object)MANUAL_ONLY), (Object)PlanBranchManagementProperties.TriggeringOption.MANUAL, (Object)((Object)CUSTOM), (Object)PlanBranchManagementProperties.TriggeringOption.CUSTOM);
    }
}

