/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HostKeyVerificationException
extends RepositoryException {
    @Nullable
    private final List<String> passwordsToObfuscate;
    @Nullable
    private final TrustedKey trustedKey;

    public HostKeyVerificationException(@NotNull String message, @Nullable Throwable cause, @Nullable TrustedKey trustedKey) {
        this(message, cause, cause == null ? "" : cause.getMessage(), cause == null ? "" : cause.getMessage(), null, trustedKey);
    }

    public HostKeyVerificationException(String message, @Nullable Throwable cause, String stdout, String stderr, @Nullable List<String> passwordsToObfuscate, @Nullable TrustedKey trustedKey) {
        super(message, cause, stdout, stderr);
        this.passwordsToObfuscate = passwordsToObfuscate;
        this.trustedKey = trustedKey;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        sb.append(", stderr:\n").append(this.getStderr());
        if (!Objects.equals(this.getStdout(), this.getStderr())) {
            sb.append("\nstdout:\n").append(this.getStdout());
        }
        return PasswordMaskingUtils.mask(sb.toString(), this.passwordsToObfuscate);
    }

    @Nullable
    public TrustedKey getTrustedKey() {
        return this.trustedKey;
    }
}

