/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.git;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.repository.git.GitAuthenticationType;
import com.atlassian.bamboo.repository.git.GitCredentialsBag;
import com.atlassian.bamboo.repository.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.repository.git.GitSshCredentialsSource;
import com.atlassian.bamboo.repository.git.cache.GitCacheKey;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@RemoteAgentSupported
@PublicApi
public interface GitConfigurationProvider {
    public static boolean isUsingSharedCredentials(@NotNull Map<String, String> serverCfg) {
        String chosenAuthentication = serverCfg.getOrDefault("repository.git.authenticationType", GitAuthenticationType.NONE.name());
        String sshCredentialsSource = serverCfg.getOrDefault("repository.git.sshCredentialsSource", GitSshCredentialsSource.CUSTOM.name());
        String passwordCredentialsSource = serverCfg.getOrDefault("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
        return GitAuthenticationType.SSH_KEYPAIR.name().equals(chosenAuthentication) && GitSshCredentialsSource.SHARED_CREDENTIALS.name().equals(sshCredentialsSource) || GitAuthenticationType.PASSWORD.name().equals(chosenAuthentication) && GitPasswordCredentialsSource.SHARED_CREDENTIALS.name().equals(passwordCredentialsSource);
    }

    @NotNull
    public static String getSharedCredentialsIdField(@NotNull Map<String, String> config) {
        return GitAuthenticationType.SSH_KEYPAIR.name().equals(config.getOrDefault("repository.git.authenticationType", GitAuthenticationType.NONE.name())) ? "repository.git.sharedCredentials" : "repository.git.passwordSharedCredentials";
    }

    @NotNull
    public String getRepositoryUrl(@NotNull VcsRepositoryData var1);

    @NotNull
    public String getSubstitutedRepositoryUrl(@NotNull VcsRepositoryData var1);

    @NotNull
    public GitCredentialsBag getCredentialsBag(@NotNull VcsRepositoryData var1);

    @NotNull
    public GitCredentialsBag substituteCredentialsBag(@NotNull GitCredentialsBag var1);

    @NotNull
    public GitCacheKey getCacheKey(@NotNull VcsRepositoryData var1);

    public static interface Constants {
        public static final String PREFIX = "repository.git.";
        public static final String REPOSITORY_GIT_REPOSITORY_URL = "repository.git.repositoryUrl";
        public static final String REPOSITORY_GIT_AUTHENTICATION_TYPE = "repository.git.authenticationType";
        public static final String REPOSITORY_GIT_SSH_CREDENTIALS_SOURCE = "repository.git.sshCredentialsSource";
        public static final String REPOSITORY_GIT_PASSWORD_CREDENTIALS_SOURCE = "repository.git.passwordCredentialsSource";
        public static final String REPOSITORY_GIT_SSH_SHAREDCREDENTIALS_ID = "repository.git.sharedCredentials";
        public static final String REPOSITORY_GIT_PASSWORD_SHAREDCREDENTIALS_ID = "repository.git.passwordSharedCredentials";
        public static final String REPOSITORY_GIT_SSH_KEY = "repository.git.ssh.key";
        public static final String REPOSITORY_GIT_SSH_PASSPHRASE = "repository.git.ssh.passphrase";
        public static final String REPOSITORY_GIT_USERNAME = "repository.git.username";
        public static final String REPOSITORY_GIT_PASSWORD = "repository.git.password";
    }
}

