/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ByJiraIssueResultSearchCriteria {
    private final List<String> issueKeys;
    private final List<String> projectKeys;

    private ByJiraIssueResultSearchCriteria(@NotNull List<String> issueKeys, @NotNull List<String> projectKeys) {
        this.issueKeys = issueKeys;
        this.projectKeys = projectKeys;
    }

    @NotNull
    public List<String> getIssueKeys() {
        return this.issueKeys;
    }

    @NotNull
    public List<String> getProjectKeys() {
        return this.projectKeys;
    }

    public static class Builder {
        private final List<String> issueKeys = new ArrayList<String>();
        private final List<String> projectKeys = new ArrayList<String>();

        public Builder issueKeys(String ... issueKeys) {
            this.issueKeys.addAll(Arrays.asList(issueKeys));
            return this;
        }

        public Builder issueKeys(@NotNull Collection<String> issueKeys) {
            this.issueKeys.addAll(issueKeys);
            return this;
        }

        public Builder projectKeys(String ... projectKeys) {
            this.projectKeys.addAll(Arrays.asList(projectKeys));
            return this;
        }

        public Builder projectKeys(@NotNull Collection<String> projectKeys) {
            this.projectKeys.addAll(projectKeys);
            return this;
        }

        public ByJiraIssueResultSearchCriteria build() {
            return new ByJiraIssueResultSearchCriteria(this.issueKeys, this.projectKeys);
        }
    }
}

