/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.search;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.plan.PlanKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
public class ResultSummarySearchCriteria {
    private static final int REASONABLE_BRS_COUNT = 10000;
    public static final int MAXIMUM_ARGUMENT_LIST_LENGTH = 1000;
    private final int maxCount;
    private final Set<LifeCycleState> lifeCycleStates;
    private final List<Long> agentIds;
    private final List<PlanKey> planKeys;
    private final Date dateFrom;
    private final Date dateTo;
    private final Date completedBefore;
    private final Date completedAfter;
    private final Boolean specsResultFlag;
    private final boolean orderedByDate;

    private ResultSummarySearchCriteria(int maxCount, @NotNull Set<LifeCycleState> lifeCycleStates, @NotNull List<Long> agentIds, @NotNull List<PlanKey> planKeys, @Nullable Date dateFrom, @Nullable Date dateTo, @Nullable Date completedBefore, @Nullable Date completedAfter, @Nullable Boolean specsResult, boolean orderedByDate) {
        this.maxCount = maxCount;
        this.agentIds = agentIds;
        this.planKeys = planKeys;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.completedBefore = completedBefore;
        this.completedAfter = completedAfter;
        this.lifeCycleStates = lifeCycleStates;
        this.specsResultFlag = specsResult;
        this.orderedByDate = orderedByDate;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public Set<LifeCycleState> getLifeCycleStates() {
        return this.lifeCycleStates;
    }

    public List<Long> getAgentIds() {
        return this.agentIds;
    }

    public List<PlanKey> getPlanKeys() {
        return this.planKeys;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public Date getCompletedBefore() {
        return this.completedBefore;
    }

    public Date getCompletedAfter() {
        return this.completedAfter;
    }

    public boolean isOrderedByDate() {
        return this.orderedByDate;
    }

    public Optional<Boolean> getSpecsResultsFlag() {
        return Optional.ofNullable(this.specsResultFlag);
    }

    public static class Builder {
        private final Set<LifeCycleState> lifeCycleStates = EnumSet.noneOf(LifeCycleState.class);
        private int maxCount = 10000;
        private final List<Long> agentIds = new ArrayList<Long>();
        private Date dateFrom = null;
        private Date dateTo = null;
        private Date completedBefore = null;
        private Date completedAfter = null;
        private final List<PlanKey> planKeys = new ArrayList<PlanKey>();
        private Boolean specsResultFlag;
        private boolean orderedByDate = true;

        public Builder lifeCycleStates(@NotNull Collection<LifeCycleState> lifeCycleStates) {
            this.lifeCycleStates.addAll(lifeCycleStates);
            return this;
        }

        public Builder lifeCycleStates(LifeCycleState ... lifeCycleStates) {
            this.lifeCycleStates.addAll(Arrays.asList(lifeCycleStates));
            return this;
        }

        public Builder agentIds(Long ... agentIds) {
            this.agentIds.addAll(Arrays.asList(agentIds));
            return this;
        }

        public Builder dateFrom(Date dateFrom) {
            this.dateFrom = dateFrom;
            return this;
        }

        public Builder dateTo(Date dateTo) {
            this.dateTo = dateTo;
            return this;
        }

        public Builder completedAfter(Date completedAfter) {
            this.completedAfter = completedAfter;
            return this;
        }

        public Builder completedBefore(Date completedBefore) {
            this.completedBefore = completedBefore;
            return this;
        }

        public Builder planKeys(PlanKey ... planKeys) {
            this.planKeys.addAll(Arrays.asList(planKeys));
            return this;
        }

        public Builder maxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public Builder specsResultFlag(boolean specsResultFlag) {
            this.specsResultFlag = specsResultFlag;
            return this;
        }

        public Builder orderedByDate(boolean orderedByDate) {
            this.orderedByDate = orderedByDate;
            return this;
        }

        public ResultSummarySearchCriteria build() {
            return new ResultSummarySearchCriteria(this.maxCount, this.lifeCycleStates, this.agentIds, this.planKeys, this.dateFrom, this.dateTo, this.completedBefore, this.completedAfter, this.specsResultFlag, this.orderedByDate);
        }
    }
}

