/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security;

import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.utils.BambooRunnables;
import org.acegisecurity.Authentication;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jetbrains.annotations.NotNull;

public class ImpersonationHelper {
    private ImpersonationHelper() {
    }

    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> void runWithSystemAuthority(@NotNull BambooRunnables.ThrowingX<E1, E2, E3> runnable) throws E2, E1, E3 {
        ImpersonationHelper.runWith((Authentication)BambooPermissionManager.SYSTEM_AUTHORITY, runnable);
    }

    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> void runWith(@NotNull Authentication authentication, @NotNull BambooRunnables.ThrowingX<E1, E2, E3> runnable) throws E2, E1, E3 {
        SecurityContext prevContext = SecurityContextHolder.getContext();
        try {
            ImpersonationHelper.newAuthenticationForCurrentThread(authentication);
            runnable.run();
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)prevContext);
        }
    }

    public static void newAuthenticationForCurrentThread(Authentication authentication) {
        SecurityContextHolder.clearContext();
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    public static Runnable makeRunnableWithSystemAuthority(Runnable runnable) {
        return () -> ImpersonationHelper.runWithSystemAuthority(BambooRunnables.from(runnable));
    }

    public static void escalateCurrentThreadToSystemAuthority() {
        ImpersonationHelper.newAuthenticationForCurrentThread((Authentication)BambooPermissionManager.SYSTEM_AUTHORITY);
    }

    public static <E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> void runAs(@NotNull BambooUser user, @NotNull BambooRunnables.ThrowingX<E1, E2, E3> runnable) throws E2, E1, E3 {
        PrincipalAcegiUserToken auth = new PrincipalAcegiUserToken("USER_TOKEN_KEY", user.getUsername(), user.getPassword(), user.getAuthorities(), (Object)user);
        ImpersonationHelper.runWith((Authentication)auth, runnable);
    }
}

