/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.atlassian.bamboo.util.Narrow;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import org.acegisecurity.acls.AclFormattingUtils;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.CumulativePermission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;

public class BambooPermission
implements Permission,
Serializable {
    public static final BambooPermission READ;
    public static final BambooPermission WRITE;
    public static final BambooPermission CREATE;
    public static final BambooPermission DELETE;
    public static final BambooPermission ADMINISTRATION;
    public static final BambooPermission SIGN_UP;
    public static final BambooPermission BUILD;
    public static final BambooPermission CLONE;
    public static final BambooPermission RESTRICTEDADMINISTRATION;
    public static final BambooPermission SOX_COMPLIANCE;
    public static final BambooPermission CREATE_REPOSITORY;
    public static final BambooPermission VIEW_CONFIGURATION;
    public static final BambooPermission APPROVE_RELEASE;
    public static final BambooPermission CREATE_PLAN_BRANCH;
    public static final BambooPermission CREATE_RELEASE;
    @Deprecated
    private static final ImmutableList<BambooPermission> DETAILED_PLAN_PERMISSIONS;
    @Deprecated
    public static final ImmutableList<BambooPermission> PLAN_RELATED_PERMISSIONS;
    public static final Set<BambooPermission> ALL_PERMISSIONS;
    private static final ImmutableSet<Permission> RESTRICTED_ADMIN_GLOBAL_PERMISSIONS;
    private static final ImmutableMap<Integer, BambooPermission> MASK_TO_PERMISSION;
    private static final ImmutableMap<String, BambooPermission> NAME_TO_PERMISSION;
    private final transient char code;
    private final transient int mask;
    private final String name;

    @Nullable
    public static String determineNameFromPermission(Permission permission) {
        return switch (permission.getMask()) {
            case 1 -> READ.getName();
            case 2 -> WRITE.getName();
            case 4 -> CREATE.getName();
            case 8 -> DELETE.getName();
            case 16 -> ADMINISTRATION.getName();
            case 32 -> SIGN_UP.getName();
            case 64 -> BUILD.getName();
            case 128 -> CLONE.getName();
            case 256 -> RESTRICTEDADMINISTRATION.getName();
            case 512 -> SOX_COMPLIANCE.getName();
            case 1024 -> CREATE_REPOSITORY.getName();
            case 2048 -> VIEW_CONFIGURATION.getName();
            case 4096 -> APPROVE_RELEASE.getName();
            case 8192 -> CREATE_PLAN_BRANCH.getName();
            case 16384 -> CREATE_RELEASE.getName();
            default -> null;
        };
    }

    private BambooPermission(int mask, char code, String name) {
        this.mask = mask;
        this.code = code;
        this.name = name;
    }

    @Deprecated
    @NotNull
    public static ImmutableList<BambooPermission> getPlanPermissionsList() {
        return PLAN_RELATED_PERMISSIONS;
    }

    public static Permission buildFromMask(int mask) {
        if (MASK_TO_PERMISSION.containsKey((Object)mask)) {
            return (Permission)MASK_TO_PERMISSION.get((Object)mask);
        }
        CumulativePermission permission = new CumulativePermission();
        for (int i = 0; i < 32; ++i) {
            int permissionToCheck = 1 << i;
            if ((mask & permissionToCheck) != permissionToCheck) continue;
            Permission p = (Permission)MASK_TO_PERMISSION.get((Object)permissionToCheck);
            Assert.state((p != null ? 1 : 0) != 0, (String)("Mask " + permissionToCheck + " does not have a corresponding static BambooPermission"));
            permission.set(p);
        }
        return permission;
    }

    public static Permission[] buildFromMask(int[] inputMasks) {
        if (inputMasks == null || inputMasks.length == 0) {
            return new Permission[0];
        }
        ArrayList<Permission> list = new ArrayList<Permission>();
        for (int mask : inputMasks) {
            list.add(BambooPermission.buildFromMask(mask));
        }
        return list.toArray(new Permission[0]);
    }

    @NotNull
    public static Permission buildFromName(String name) {
        BambooPermission bambooPermission = (BambooPermission)NAME_TO_PERMISSION.get((Object)name);
        Assert.isTrue((bambooPermission != null ? 1 : 0) != 0, (String)("Unknown permission '" + name + "'"));
        return bambooPermission;
    }

    public static Permission[] buildFromName(String[] names) {
        if (names == null || names.length == 0) {
            return new Permission[0];
        }
        ArrayList<Permission> list = new ArrayList<Permission>();
        for (String name : names) {
            list.add(BambooPermission.buildFromName(name));
        }
        return list.toArray(new Permission[0]);
    }

    public static boolean isGlobalPermissionGrantedForRestrictedAdmin(Permission permission) {
        return RESTRICTED_ADMIN_GLOBAL_PERMISSIONS.contains((Object)permission);
    }

    public static BambooPermission convertToBambooPermission(Permission permission) {
        BambooPermission bambooPermission = Narrow.downTo(permission, BambooPermission.class);
        if (bambooPermission != null) {
            return bambooPermission;
        }
        return (BambooPermission)MASK_TO_PERMISSION.get((Object)permission.getMask());
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof BambooPermission)) {
            return false;
        }
        BambooPermission rhs = (BambooPermission)arg0;
        return this.mask == rhs.getMask();
    }

    public int hashCode() {
        return this.mask;
    }

    private Object readResolve() throws ObjectStreamException {
        return BambooPermission.buildFromName(this.name);
    }

    public int getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return AclFormattingUtils.printBinary((int)this.mask, (char)this.code);
    }

    public String toString() {
        return "BambooPermission[" + this.getPattern() + "=" + this.mask + "]";
    }

    static {
        Field[] fields;
        READ = new BambooPermission(1, 'R', "READ");
        WRITE = new BambooPermission(2, 'W', "WRITE");
        CREATE = new BambooPermission(4, 'C', "CREATE");
        DELETE = new BambooPermission(8, 'D', "DELETE");
        ADMINISTRATION = new BambooPermission(16, 'A', "ADMINISTRATION");
        SIGN_UP = new BambooPermission(32, 'S', "SIGN_UP");
        BUILD = new BambooPermission(64, 'B', "BUILD");
        CLONE = new BambooPermission(128, 'O', "CLONE");
        RESTRICTEDADMINISTRATION = new BambooPermission(256, 'X', "RESTRICTEDADMINISTRATION");
        SOX_COMPLIANCE = new BambooPermission(512, 'U', "SOXCOMPLIANCE");
        CREATE_REPOSITORY = new BambooPermission(1024, 'Z', "CREATEREPOSITORY");
        VIEW_CONFIGURATION = new BambooPermission(2048, 'V', "VIEWCONFIGURATION");
        APPROVE_RELEASE = new BambooPermission(4096, 'E', "APPROVERELEASE");
        CREATE_PLAN_BRANCH = new BambooPermission(8192, 'P', "CREATEPLANBRANCH");
        CREATE_RELEASE = new BambooPermission(16384, 'L', "CREATERELEASE");
        DETAILED_PLAN_PERMISSIONS = ImmutableList.of((Object)READ, (Object)WRITE, (Object)CREATE, (Object)DELETE, (Object)BUILD, (Object)CLONE, (Object)VIEW_CONFIGURATION, (Object)CREATE_PLAN_BRANCH);
        PLAN_RELATED_PERMISSIONS = ImmutableList.builder().addAll(DETAILED_PLAN_PERMISSIONS).add((Object)ADMINISTRATION).build();
        ALL_PERMISSIONS = ImmutableSet.of((Object)SIGN_UP, (Object)READ, (Object)CREATE, (Object)WRITE, (Object)DELETE, (Object)BUILD, (Object[])new BambooPermission[]{CLONE, CREATE_REPOSITORY, SOX_COMPLIANCE, RESTRICTEDADMINISTRATION, ADMINISTRATION, VIEW_CONFIGURATION, APPROVE_RELEASE, CREATE_PLAN_BRANCH, CREATE_RELEASE});
        RESTRICTED_ADMIN_GLOBAL_PERMISSIONS = ImmutableSet.of((Object)READ, (Object)CREATE, (Object)CREATE_REPOSITORY);
        ImmutableMap.Builder maskToPermissionBuilder = ImmutableMap.builder();
        ImmutableMap.Builder nameToPermissionBuilder = ImmutableMap.builder();
        for (Field field : fields = BambooPermission.class.getDeclaredFields()) {
            try {
                Object fieldValue = field.get(null);
                if (!BambooPermission.class.isAssignableFrom(fieldValue.getClass())) continue;
                BambooPermission perm = (BambooPermission)fieldValue;
                maskToPermissionBuilder.put((Object)perm.getMask(), (Object)perm);
                nameToPermissionBuilder.put((Object)perm.getName(), (Object)perm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MASK_TO_PERMISSION = maskToPermissionBuilder.build();
        NAME_TO_PERMISSION = nameToPermissionBuilder.build();
    }
}

