/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.trustedapplications;

import com.atlassian.bamboo.utils.Validations;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class KeyUtils {
    private static final Logger log = Logger.getLogger(KeyUtils.class);

    private KeyUtils() {
    }

    public static KeyPair generateNewKeyPair(EncryptionProvider encryptionProvider) {
        try {
            return encryptionProvider.generateNewKeyPair();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encode(Key key) {
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static PrivateKey decodePrivateKey(EncryptionProvider encryptionProvider, String keyStr) {
        try {
            byte[] data = Base64.decodeBase64((String)keyStr);
            return encryptionProvider.toPrivateKey(data);
        }
        catch (Exception e) {
            log.error((Object)("decodePrivateKey: " + String.valueOf(e)));
            return new InvalidPrivateKey(e);
        }
    }

    public static PublicKey decodePublicKey(EncryptionProvider encryptionProvider, String keyStr) {
        try {
            byte[] data = Base64.decodeBase64((String)keyStr);
            return encryptionProvider.toPublicKey(data);
        }
        catch (Exception e) {
            log.error((Object)("decodePublicKey: [" + keyStr + "]"), (Throwable)e);
            return new InvalidPublicKey(e);
        }
    }

    @NotNull
    public static KeyPair decodeKeyPair(@NotNull EncryptionProvider encryptionProvider, @NotNull String publicKeyStr, @NotNull String privateKeyStr) {
        PublicKey publicKey = KeyUtils.decodePublicKey(encryptionProvider, publicKeyStr);
        PrivateKey privateKey = KeyUtils.decodePrivateKey(encryptionProvider, privateKeyStr);
        Validations.checkArgument(!(publicKey instanceof InvalidKey), "Invalid public key: " + publicKeyStr, new Object[0]);
        Validations.checkArgument(!(privateKey instanceof InvalidKey), "Invalid private key: " + privateKeyStr, new Object[0]);
        return new KeyPair(publicKey, privateKey);
    }

    public static class InvalidPrivateKey
    extends InvalidKey
    implements PrivateKey {
        public InvalidPrivateKey(Exception cause) {
            super(cause);
        }
    }

    public static class InvalidPublicKey
    extends InvalidKey
    implements PublicKey {
        public InvalidPublicKey(Exception cause) {
            super(cause);
        }
    }

    public static class InvalidKey
    implements Key {
        private final Exception cause;

        InvalidKey(Exception cause) {
            this.cause = cause;
        }

        @Override
        public String getAlgorithm() {
            return "";
        }

        @Override
        public String getFormat() {
            return "";
        }

        @Override
        public byte[] getEncoded() {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }

        public String toString() {
            return "Invalid Key: " + String.valueOf(this.cause);
        }

        public Exception getCause() {
            return this.cause;
        }
    }
}

