/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.utils.Throwables;
import com.atlassian.bamboo.utils.Validations;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooObjectUtils {
    private BambooObjectUtils() {
    }

    @Deprecated
    public static <T extends Comparable<T>> int compare(@Nullable T lhs, @Nullable T rhs) {
        return ObjectUtils.compare(lhs, rhs);
    }

    public static String getId(@Nullable Object o) {
        if (o != null) {
            return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
        }
        return null;
    }

    public static <T extends Throwable, C extends T> RuntimeException rethrowAnyCauseThatIsInstanceOf(@NotNull T t, Class<C> toRethrowC) throws C {
        for (Throwable cause : Throwables.getCausalChain(t)) {
            Throwables.throwIfInstanceOf(cause, toRethrowC);
        }
        return BambooObjectUtils.asRuntimeException(t);
    }

    @NotNull
    public static String getMessageOrStackTrace(@NotNull Throwable throwable) {
        String message = throwable.getMessage();
        if (message != null && !message.equalsIgnoreCase("null")) {
            return message;
        }
        return throwable.getClass().getCanonicalName() + ": " + Arrays.toString(throwable.getStackTrace());
    }

    public static <T extends Throwable> RuntimeException asRuntimeException(T t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException("Unexpected exception", t);
    }

    public static String toString(Object key) {
        if (key.getClass().isArray()) {
            return Arrays.toString((Object[])key);
        }
        return key.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getCached(@NotNull AtomicReference<T> valueHolder, @NotNull Supplier<T> valueSupplier) {
        AtomicReference<T> atomicReference = valueHolder;
        synchronized (atomicReference) {
            if (valueHolder.get() == null) {
                valueHolder.set(Validations.checkNotNull(valueSupplier.get()));
            }
            return valueHolder.get();
        }
    }
}

