/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordMaskingUtils {
    public static final String PASSWORD_MASK = "********";
    public static final List<String> PASSWORD_FIELD_NAMES = ImmutableList.of((Object)"password", (Object)"sshKey", (Object)"secret", (Object)"passphrase");
    public static final Pattern URL_PASSWORD_PATTERN = Pattern.compile("^([a-zA-Z0-9]+)://([^:/@]+):([^:/@]+)@(.*)$");
    private static final Function<? extends VariableDefinitionContext, ? extends VariableDefinitionContext> MASK_VARIABLE_IF_NEEDED = input -> {
        if (PasswordMaskingUtils.shouldBeMasked(input)) {
            input.setValue(PASSWORD_MASK);
            VariableDefinition vd = Narrow.downTo(input, VariableDefinition.class);
            if (vd != null) {
                vd.setId(-vd.getId());
            }
        }
        return input;
    };
    public static Predicate<VariableDefinitionContext> SHOULD_VARIABLE_BE_MASKED = variable -> PasswordMaskingUtils.shouldBeMasked(variable.getKey());

    private PasswordMaskingUtils() {
    }

    public static boolean isMasked(@Nullable String value) {
        return PASSWORD_MASK.equals(value);
    }

    public static boolean shouldBeMasked(@Nullable String variableName) {
        return PASSWORD_FIELD_NAMES.stream().anyMatch(pattern -> StringUtils.containsIgnoreCase((CharSequence)variableName, (CharSequence)pattern));
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinition variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinitionContext variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldBeMasked(@NotNull VariableSubstitutionContext variableSubstitutionContext) {
        return PasswordMaskingUtils.shouldBeMasked(variableSubstitutionContext.getKey());
    }

    public static boolean shouldIgnoreValue(String key, String value) {
        return PasswordMaskingUtils.shouldBeMasked(key) && PasswordMaskingUtils.isMasked(value);
    }

    public static <T extends VariableDefinitionContext> Collection<? extends T> maskPasswordValues(@NotNull Collection<T> variables, @NotNull Function<? super T, ? extends T> clone) {
        return variables.stream().map(clone.andThen(MASK_VARIABLE_IF_NEEDED)).collect(Collectors.toList());
    }

    public static String mask(@NotNull String string, @Nullable String password) {
        if (StringUtils.isEmpty((CharSequence)password) || StringUtils.containsOnly((CharSequence)password, (char[])new char[]{'*'})) {
            return string;
        }
        String afterFirstReplace = string.replace(password, PASSWORD_MASK);
        String encodedPassword = HtmlUtils.encodeUrl(password);
        if (!password.equals(encodedPassword)) {
            return afterFirstReplace.replace(encodedPassword, PASSWORD_MASK);
        }
        return afterFirstReplace;
    }

    public static String mask(@NotNull String string, @Nullable Iterable<String> passwords) {
        if (passwords != null) {
            HashSet uniquePasswords = Sets.newHashSet(passwords);
            for (String password : uniquePasswords) {
                string = PasswordMaskingUtils.mask(string, password);
            }
        }
        return string;
    }

    public static Iterable<String> findPossiblePasswordValues(Collection<VariableDefinitionContext> variables) {
        ArrayList<String> possiblePasswordValues = new ArrayList<String>();
        for (VariableDefinitionContext variableDefinitionContext : variables) {
            if (!PasswordMaskingUtils.shouldBeMasked(variableDefinitionContext.getKey())) continue;
            possiblePasswordValues.add(variableDefinitionContext.getValue());
        }
        return possiblePasswordValues;
    }

    public static String maskPossiblePasswordValues(String text, VariableContext variableContext) {
        Set uniquePasswordValues = BambooIterables.stream(variableContext.getPasswordVariables()).map(VariableDefinitionContext::getValue).flatMap(value -> Stream.of(value, value.replace("\\", ""), Base64.getEncoder().encodeToString(value.getBytes(Charset.defaultCharset())))).collect(Collectors.toCollection(LinkedHashSet::new));
        for (String pass : uniquePasswordValues) {
            if (!StringUtils.isNotBlank((CharSequence)pass)) continue;
            text = PasswordMaskingUtils.mask(text, pass);
        }
        return text;
    }

    @NotNull
    public static String maskUrlPassword(@NotNull String url) {
        Matcher matcher = URL_PASSWORD_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.replaceAll("$1://$2:********@$4");
        }
        return url;
    }

    @Nullable
    public static String getPasswordFromUrl(@NotNull String url) {
        Matcher matcher = URL_PASSWORD_PATTERN.matcher(url);
        return matcher.matches() ? matcher.group(3) : null;
    }

    @NotNull
    public static Map<String, VariableDefinitionContext> removePasswordVariables(@NotNull Map<String, VariableDefinitionContext> variables) {
        return Maps.filterKeys(variables, v -> !PasswordMaskingUtils.shouldBeMasked(v));
    }

    @NotNull
    public static Iterable<String> removePasswordVariables(@NotNull Iterable<String> variables) {
        return Iterables.filter(variables, v -> !PasswordMaskingUtils.shouldBeMasked(v));
    }

    @NotNull
    public static <T extends VariableDefinitionContext> Iterable<T> removePasswordVariableDefinitions(@NotNull Iterable<T> variables) {
        return Iterables.filter(variables, v -> !PasswordMaskingUtils.shouldBeMasked(v));
    }
}

