/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.Validations;
import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import com.atlassian.bamboo.utils.collection.multimap.SetMultimap;
import com.google.common.base.Splitter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlUtils {
    private static final Pattern XSS_RELATED_CHARACTERS_REGEX = Pattern.compile("[\"'<>\\\\]");
    private static final String SCHEME_DELIMITER = "://";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";

    private UrlUtils() {
    }

    @NotNull
    public static String sanitizeUri(@NotNull String uri) {
        return XSS_RELATED_CHARACTERS_REGEX.matcher(uri).replaceAll("");
    }

    @Nullable
    public static String replaceOrInsertParamValue(String queryString, String newParamValue) {
        if (queryString == null) {
            return null;
        }
        if (!((String)queryString).contains("buildNumber=")) {
            queryString = ((String)queryString).contains("?") ? (((String)queryString).endsWith("&") ? (String)queryString + "buildNumber=" + newParamValue : (String)queryString + "&buildNumber=" + newParamValue) : (String)queryString + "?buildNumber=" + newParamValue;
            return queryString;
        }
        return ((String)queryString).replaceAll("buildNumber=[0-9]*", "buildNumber=" + newParamValue);
    }

    public static String replacePlanResultKeyInUrl(String url, PlanKey planKey, int newBuildNumber) {
        return url.replaceFirst(String.valueOf(planKey) + "-[0-9]+", PlanKeys.getPlanResultKey(planKey, newBuildNumber).getKey());
    }

    public static String correctlyFormatUrl(String host) {
        if (host == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)host)) {
            return host;
        }
        StringBuilder urlToReturn = new StringBuilder(host);
        if (!host.startsWith("http://") && !host.startsWith("https://")) {
            urlToReturn.insert(0, "http://");
        }
        while (urlToReturn.charAt(urlToReturn.length() - 1) == '/') {
            urlToReturn.deleteCharAt(urlToReturn.length() - 1);
        }
        return urlToReturn.toString();
    }

    @NotNull
    public static String stripLeadingSlashes(@Nullable String toStrip) {
        int i;
        if (toStrip == null) {
            return "";
        }
        for (i = 0; toStrip.length() > i && '/' == toStrip.charAt(i); ++i) {
        }
        return toStrip.substring(i);
    }

    @NotNull
    public static String stripTailingSlashes(@Nullable String toStrip) {
        while (toStrip != null && toStrip.endsWith("/")) {
            toStrip = toStrip.replaceAll("/$", "");
        }
        if (toStrip == null) {
            return "";
        }
        return toStrip;
    }

    @NotNull
    public static String appendSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.endsWith("/")) {
            return theString + "/";
        }
        return theString;
    }

    @NotNull
    public static String prependSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.startsWith("/")) {
            return "/" + theString;
        }
        return theString;
    }

    @NotNull
    public static String stripQueryAndRef(@NotNull String url) {
        try {
            URL parsedUrl = new URL(url);
            return new URL(parsedUrl.getProtocol(), parsedUrl.getHost(), parsedUrl.getPort(), parsedUrl.getPath()).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static Multimap<String, String> extractQueryParams(@NotNull URL url) {
        return UrlUtils.queryToMultimap(UrlUtils.getQuery(url));
    }

    @NotNull
    public static Multimap<String, String> extractQueryParams(@NotNull String url) {
        return UrlUtils.queryToMultimap(UrlUtils.getQuery(url));
    }

    @NotNull
    public static Multimap<String, String> extractQueryParams(@NotNull URI uri) {
        return UrlUtils.queryToMultimap(UrlUtils.getQuery(uri));
    }

    @Nullable
    public static String extractSingleQueryParam(@NotNull URL url, @NotNull String paramName) {
        Multimap<String, String> allParams = UrlUtils.extractQueryParams(url);
        return UrlUtils.getFirstParam(allParams, paramName);
    }

    @Nullable
    public static String extractSingleQueryParam(@NotNull String url, @NotNull String paramName) {
        Multimap<String, String> allParams = UrlUtils.extractQueryParams(url);
        return UrlUtils.getFirstParam(allParams, paramName);
    }

    public static boolean isSameOrigin(@NotNull URL url, @NotNull URL origin) {
        return origin.getProtocol().equals(url.getProtocol()) && origin.getPort() == url.getPort() && origin.getHost().equalsIgnoreCase(url.getHost());
    }

    @NotNull
    public static URL createUrl(@NotNull String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw BambooObjectUtils.asRuntimeException(e);
        }
    }

    @NotNull
    public static URL createUrl(@NotNull String context, @NotNull String formActionDestination) {
        URL contextUrl = UrlUtils.createUrl(context);
        try {
            return new URL(contextUrl, formActionDestination);
        }
        catch (MalformedURLException e) {
            throw BambooObjectUtils.asRuntimeException(e);
        }
    }

    public static String constructBaseUrl(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        String scheme = request.getScheme();
        sb.append(scheme);
        sb.append(SCHEME_DELIMITER);
        sb.append(request.getServerName());
        int port = request.getServerPort();
        if (!UrlUtils.isStandardPort(scheme, port)) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME) && port == 80) {
            return true;
        }
        return scheme.equalsIgnoreCase(HTTPS_SCHEME) && port == 443;
    }

    public static boolean hasXssRelatedCharacters(@Nullable String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return UrlUtils.hasUrlXssCharacters(string) || UrlUtils.hasUrlXssCharacters(StringEscapeUtils.unescapeHtml4((String)string));
    }

    private static boolean hasUrlXssCharacters(String string) {
        return XSS_RELATED_CHARACTERS_REGEX.matcher(string).find();
    }

    @NotNull
    private static Multimap<String, String> queryToMultimap(@NotNull CharSequence query) {
        SetMultimap<String, String> params = SetMultimap.create();
        for (String keyValue : Splitter.on((String)"&").split(query)) {
            params.put(StringUtils.substringBefore((String)keyValue, (String)"="), StringUtils.substringAfter((String)keyValue, (String)"="));
        }
        return params;
    }

    @NotNull
    private static String getQuery(@NotNull URL url) {
        return StringUtils.defaultString((String)url.getQuery());
    }

    @NotNull
    private static String getQuery(@NotNull URI uri) {
        return StringUtils.defaultString((String)uri.getQuery());
    }

    @NotNull
    private static String getQuery(@NotNull String url) {
        return StringUtils.substringAfter((String)url, (String)"?");
    }

    @Nullable
    private static String getFirstParam(Multimap<String, String> params, @NotNull String paramName) {
        Collection<String> matchingParams = params.get(paramName);
        Validations.checkArgument(matchingParams.size() <= 1, String.format("Expected no more than one '%s' parameter in query", paramName), new Object[0]);
        return matchingParams.stream().findFirst().orElse(null);
    }
}

