/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.Throwables;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.function.Predicate;

public class BambooCallables {
    private BambooCallables() {
    }

    public static <V> V callUnchecked(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <V> NotThrowing<V> notThrowing(ThrowingX<V, ? extends Exception, ? extends Exception, ? extends Exception> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        };
    }

    public static <V, E extends Throwable> V retryOnException(Throwing<V, E> callable, Class<E> exceptionClass) throws E {
        return BambooCallables.retryOnException(callable, exceptionClass, 1L);
    }

    public static <V, E extends Throwable> V retryOnException(Throwing<V, E> callable, Class<E> exceptionClass, long howManyRetries) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (exceptionClass.isInstance(e)) {
                if (howManyRetries > 0L) {
                    return BambooCallables.retryOnException(callable, exceptionClass, howManyRetries - 1L);
                }
                throw e;
            }
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <V, E extends Throwable> V retryOnExceptions(Throwing<V, E> callable, Class<? extends Throwable> ... exceptionClass) throws E {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            if (Arrays.stream(exceptionClass).anyMatch(c -> c.isInstance(e))) {
                return callable.call();
            }
            throw e;
        }
    }

    public static <V> V retryOnException(NotThrowing<V> callable, Predicate<RuntimeException> exceptionPredicate) {
        return BambooCallables.retryOnException(callable, exceptionPredicate, 1);
    }

    public static <V> V retryOnException(NotThrowing<V> callable, Predicate<RuntimeException> exceptionPredicate, int maxRetryCount) {
        int retryCount = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (RuntimeException e) {
                if (retryCount >= maxRetryCount || !exceptionPredicate.test(e)) {
                    throw e;
                }
                ++retryCount;
                continue;
            }
            break;
        }
    }

    public static interface ThrowingX<V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> {
        public V call() throws E1, E2, E3;
    }

    public static interface NotThrowing<V>
    extends ThrowingX<V, RuntimeException, RuntimeException, RuntimeException> {
    }

    public static interface Throwing<V, E1 extends Throwable>
    extends ThrowingX<V, E1, RuntimeException, RuntimeException> {
    }

    private static interface Throwing3<V, E1 extends Throwable, E2 extends Throwable, E3 extends Throwable>
    extends ThrowingX<V, E1, E2, E3> {
    }

    public static interface Throwing2<V, E1 extends Throwable, E2 extends Throwable>
    extends ThrowingX<V, E1, E2, RuntimeException> {
    }

    public static interface Throwing1<V, E1 extends Throwable>
    extends ThrowingX<V, E1, RuntimeException, RuntimeException> {
    }
}

