/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.Throwables;
import com.atlassian.bamboo.utils.Validations;
import com.google.common.util.concurrent.Runnables;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class BambooRunnables {
    private BambooRunnables() {
    }

    public static <V> RunnableFromCallable<V> asJavaRunnable(Callable<V> callable) {
        return new RunnableFromCallable<V>(callable);
    }

    public static <V> BambooRunnableFromCallable<V> asBambooRunnable(Callable<V> callable) {
        return new BambooRunnableFromCallable<V>(callable);
    }

    public static NotThrowing from(final Runnable runnable) {
        return new NotThrowing(){

            @Override
            public void run() {
                runnable.run();
            }
        };
    }

    public static Runnable runOnce(Runnable code) {
        return new RunnableOnce(code);
    }

    public static void runUnchecked(ThrowingX<? extends Exception, ? extends Exception, ? extends Exception> throwingRunnable) {
        try {
            throwingRunnable.run();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static class RunnableFromCallable<V>
    implements Runnable {
        private final Callable<V> callable;
        private Either<? extends Exception, V> result = Either.left((Object)new IllegalStateException("Runnable not called"));

        private RunnableFromCallable(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                this.result = Either.right(this.callable.call());
            }
            catch (Exception e) {
                this.result = Either.left((Object)e);
            }
        }

        public V getOrThrow() throws Exception {
            return (V)Eithers.getOrThrow(this.result);
        }
    }

    public static class BambooRunnableFromCallable<V>
    implements Throwing1<Exception> {
        private final Callable<V> callable;
        private volatile AtomicReference<V> result;
        private volatile boolean isRun = false;

        public BambooRunnableFromCallable(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public void run() throws Exception {
            this.isRun = true;
            this.result = new AtomicReference<V>(this.callable.call());
        }

        public V get() {
            Validations.checkState(this.isRun, "get() called before run()");
            Validations.checkState(this.result != null, "get() called although exception has been reported");
            return this.result.get();
        }
    }

    private static class RunnableOnce
    implements Runnable {
        private final AtomicReference<Runnable> code;

        public RunnableOnce(Runnable code) {
            this.code = new AtomicReference<Runnable>(code);
        }

        @Override
        public void run() {
            this.code.getAndSet(Runnables.doNothing()).run();
        }
    }

    public static interface ThrowingX<E1 extends Throwable, E2 extends Throwable, E3 extends Throwable> {
        public void run() throws E1, E2, E3;
    }

    private static interface Throwing3<E1 extends Throwable, E2 extends Throwable, E3 extends Throwable>
    extends ThrowingX<E1, E2, E3> {
    }

    public static interface Throwing2<E1 extends Throwable, E2 extends Throwable>
    extends ThrowingX<E1, E2, RuntimeException> {
    }

    public static interface Throwing1<E1 extends Throwable>
    extends ThrowingX<E1, RuntimeException, RuntimeException> {
    }

    public static interface Throwing<E1 extends Throwable>
    extends ThrowingX<E1, RuntimeException, RuntimeException> {
    }

    public static interface NotThrowing
    extends ThrowingX<RuntimeException, RuntimeException, RuntimeException> {
    }
}

