/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ByteSource {
    private byte[] data;

    protected ByteSource() {
    }

    public ByteSource(byte[] data) {
        this.data = data;
    }

    public static ByteSource fromPath(Path path) throws IOException {
        return new ByteSource(Files.readAllBytes(path));
    }

    public InputStream openStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public void copyTo(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public String hash(String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        byte[] hash = digest.digest(this.data);
        return this.bytesToHex(hash);
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public ByteSource slice(int offset, int length) {
        byte[] slice = new byte[length];
        System.arraycopy(this.data, offset, slice, 0, length);
        return new ByteSource(slice);
    }
}

