/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.util.Comparator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pair<A, B> {
    public final A first;
    public final B second;

    @Deprecated
    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    @Nullable
    public A getFirst() {
        return this.first;
    }

    @Nullable
    public B getSecond() {
        return this.second;
    }

    public int compareTo(Pair obj) {
        return new CompareToBuilder().append(this.first, obj.first).append(this.second, obj.second).toComparison();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.first != null ? !this.first.equals(pair.first) : pair.first != null) {
            return false;
        }
        return !(this.second != null ? !this.second.equals(pair.second) : pair.second != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    @NotNull
    public static <A, B> Pair<A, B> make(@Nullable A first, @Nullable B second) {
        return new Pair<A, B>(first, second);
    }

    public static <T extends Comparable, U extends Comparable> Comparator<Pair<T, U>> pairOfComparableComparator() {
        return (o1, o2) -> new CompareToBuilder().append(o1.getFirst(), o2.getFirst()).append(o1.getSecond(), o2.getSecond()).toComparison();
    }

    public String toString() {
        return "{" + String.valueOf(this.first) + "," + String.valueOf(this.second) + "}";
    }
}

