/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.util.UrlUtils;
import com.atlassian.bamboo.utils.AbstractSystemProperty;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SystemProperty
extends AbstractSystemProperty {
    public static final String BAMBOO_HOME_PROPERTY_NAME = "bamboo.home";
    public static final String BAMBOO_HOME_SHARED_PROPERTY_NAME = "bamboo.shared.home";
    public static final String BAMBOO_AGENT_BROKER_URL_PROPERTY_NAME = "bamboo.agent.brokerUrl";
    public static final long PER_NODE_QUEUE_STATS_LOGGING_INTERVAL_MINUTES_DEFAULT = 10L;
    public static final SystemProperty BAMBOO_HOME_FROM_ENV = new SystemProperty(false, "bamboo.home", "BAMBOO_HOME");
    public static final SystemProperty BAMBOO_HOME_SHARED_FROM_ENV = new SystemProperty(false, "bamboo.shared.home", "BAMBOO_SHARED_HOME");
    public static final SystemProperty MAVEN_HOME = new SystemProperty(false, "MAVEN_HOME");
    public static final SystemProperty MAVEN2_HOME = new SystemProperty(false, "M2_HOME", "MAVEN2_HOME");
    public static final SystemProperty ANT_HOME = new SystemProperty(false, "ANT_HOME");
    public static final SystemProperty FIND_SUCCESS_MESSAGE_IN_LAST = new SystemProperty(false, "SUCCESS_MESSAGE_LINES");
    public static final SystemProperty BUILD_SUCCESSFUL_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.successMarker");
    public static final SystemProperty BUILD_FAILED_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.failedMarker");
    public static final SystemProperty SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = new SystemProperty(false, "bamboo.build.searchSuccessFailMessageEverywhere");
    public static final BooleanSystemProperty DISABLE_AGENT_AUTO_CAPABILITY_DETECTION = new BooleanSystemProperty(false, false, "DISABLE_AGENT_AUTO_CAPABILITY_DETECTION");
    public static final BooleanSystemProperty DISABLE_AGENT_CAPABILITY_UPDATE = new BooleanSystemProperty(false, false, "bamboo.disable.capabilities.properties.file");
    public static final BooleanSystemProperty REMOTE_AGENT_AUTHENTICATION_ENABLED = new BooleanSystemProperty(false, true, "bamboo.setup.remote.agent.authentication.enabled");
    public static final BooleanSystemProperty REMOTE_AGENT_SECURITY_TOKEN_ENABLED = new BooleanSystemProperty(false, false, "bamboo.setup.remote.agent.security.token.enabled");
    public static final SystemProperty REMOTE_AGENT_SECURITY_TOKEN_VALUE = new SystemProperty(false, "bamboo.setup.remote.agent.security.token.value");
    public static final BooleanSystemProperty LOCAL_AGENTS_DISABLED = new BooleanSystemProperty(false, true, "bamboo.local.agents.disabled");
    public static final BooleanSystemProperty DELETE_REMOTE_AGENTS_ON_GOING_OFFLINE = new BooleanSystemProperty(false, false, "bamboo.delete.remote.agents.on.going.offline");
    public static final SystemProperty SVN_SPOOL_TO_FILE = new SystemProperty(false, "SVN_SPOOL_TO_FILE");
    public static final SystemProperty BUILDING_DISABLED = new SystemProperty(false, "atlassian.bamboo.build.disable");
    public static final SystemProperty PATH = new SystemProperty(false, "PATH", "Path", "path");
    public static final SystemProperty BUILD_RESULTS_CACHE_SIZE = new SystemProperty(false, "BUILD_RESULTS_CACHE_SIZE");
    public static final SystemProperty FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS = new SystemProperty(false, "FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS");
    @Deprecated
    public static final SystemProperty SVN_WC_FORMAT = new SystemProperty(false, "bamboo.svn.wc.format");
    public static final SystemProperty SVN_CACHE_CREDENTIALS = new SystemProperty(false, "bamboo.svn.cache.credentials");
    public static final IntegerSystemProperty LOG_LINES_FOR_NOTIFICATIONS = new IntegerSystemProperty(false, 100L, "bamboo.notifications.logLinesToInclude");
    public static final IntegerSystemProperty FS_TIMESTAMP_RESOLUTION_MS = new IntegerSystemProperty(false, SystemProperty.getFilesystemTimestampResolution(), "bamboo.fs.timestamp.precision");
    public static final SystemProperty SEND_FILE_NAMES_TO_AGENT = new SystemProperty(false, "bamboo.send.file.names.to.agent");
    public static final SystemProperty ELASTIC_IMAGE_AMI_ID = new SystemProperty(false, "bamboo.aws.amiId");
    public static final IntegerSystemProperty MAXIMUM_ALLOWED_ELASTIC_AGENT_STARTUP_TIME_MINUTES = new IntegerSystemProperty(false, 55L, "bamboo.ec2.maximum.agent.startup.time");
    public static final BooleanSystemProperty EC2_HTTP_TUNNEL_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec2.tunnel.enabled");
    public static final IntegerSystemProperty ELASTIC_AGENT_TUNNEL_TIMEOUT_MINUTES = new IntegerSystemProperty(false, 40L, "bamboo.ec2.agent.tunnel.timeout");
    public static final BooleanSystemProperty EC2_JMS_TUNNEL_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec2.tunnel.jms.enabled");
    public static final BooleanSystemProperty ENABLE_JMS_SSL_ENDPOINT = new BooleanSystemProperty(false, true, "bamboo.jms.ssl.endpoint.enabled");
    public static final IntegerSystemProperty EC2_TUNNEL_KEY_LENGTH = new IntegerSystemProperty(false, 2048L, "bamboo.ec2.tunnel.key.length");
    public static final SystemProperty EC2_IGNORE_CERT_CHECK = new SystemProperty(false, "bamboo.ec2.ignoreCertCheck");
    public static final SystemProperty ELASTIC_BAMBOO_CUSTOM_ENTITY = new SystemProperty(false, "bamboo.ec2.entity.name");
    public static final SystemProperty FIRE_INITIAL_BUILD_FOR_MANUAL_STRATEGY = new SystemProperty(false, "fire.initial.build.for.manual.strategy");
    public static final BooleanSystemProperty INITIAL_BUILD_ENABLED = new BooleanSystemProperty(false, true, "bamboo.fire.initial.build.enabled");
    public static final boolean PATH_SET_ALLOWED = new SystemProperty(false, "bamboo.paths.set.allowed").getValue(false);
    public static final SystemProperty BUILD_PARENT_JAVA_IO_TMPDIR = new SystemProperty(false, "bamboo.build.parent.java.io.tmpdir", "java.io.tmpdir");
    public static final SystemProperty EVENT_MANAGER_CORE_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.corePoolSize");
    public static final SystemProperty EVENT_MANAGER_MAXIMUM_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.maximumPoolSize");
    public static final SystemProperty DIRECTORY_SCANNING_PLUGIN_SCAN_DIR = new SystemProperty(false, "atlassian.bamboo.plugin.scan.directory");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_ID = new SystemProperty(false, "bamboo.ec2.agentLogAwsId");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_SECRET = new SystemProperty(false, "bamboo.ec2.agentLogSecret");
    public static final SystemProperty BAMBOO_DELETION_ENABLED = new SystemProperty(false, "bamboo.deletion.enabled");
    public static final SystemProperty BAMBOO_RELOAD_AGENT_CLASSPATH = new SystemProperty(false, "bamboo.agent.reloadclasspath");
    public static final SystemProperty BAMBOO_MAX_AGENTS_LOADING = new SystemProperty(false, "bamboo.agent.max_loading");
    public static final SystemProperty BAMBOO_FREEMARKER_DEBUG = new SystemProperty(false, "bamboo.freemarker.debug");
    public static final SystemProperty MAX_VCS_OPERATION_RETRIES = new SystemProperty(false, "bamboo.vcs.retries");
    public static final IntegerSystemProperty PLAN_EXECUTION_DETECTION_THREADS = new IntegerSystemProperty(false, 8L, "bamboo.plan.exe.threads");
    public static final IntegerSystemProperty PLAN_EXECUTION_IDLE_TIMEOUT = new IntegerSystemProperty(false, 30L, "bamboo.plan.exe.idle.timeout");
    public static final IntegerSystemProperty BRANCH_CREATION_THREADS = new IntegerSystemProperty(false, 4L, "bamboo.branch.creation.threads");
    public static final IntegerSystemProperty CHAIN_EXECUTION_DETECTION_THREADS = new IntegerSystemProperty(false, PLAN_EXECUTION_DETECTION_THREADS.getTypedValue(), "bamboo.chain.exec.threads");
    public static final BooleanSystemProperty PLAN_EXECUTION_PRIORITIZING_ENABLED = new BooleanSystemProperty(false, true, "bamboo.plan.exe.prioritizing.enabled");
    public static final IntegerSystemProperty SPECS_DETECTION_THREADS = new IntegerSystemProperty(false, 4L, "bamboo.specs.detection.threads");
    public static final SystemProperty ARTIFACT_COMPRESSION_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.artifactcompression");
    public static final SystemProperty ROTP_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.rotp");
    public static final SystemProperty ROTP_PROJECT_SHORTCUTS_DARK_FEATURE = new SystemProperty(false, "atlassian.darkfeature.rotp.project.shortcuts");
    public static final SystemProperty ROTP_ADMIN_SHORTCUTS_DARK_FEATURE = new SystemProperty(false, "atlassian.darkfeature.rotp.admin.shortcuts");
    public static final SystemProperty PDL_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.pdl");
    public static final SystemProperty ARTIFACT_SIZE_LIMIT_PER_BUILD = new SystemProperty(false, "bamboo.artifact.size.limit.per.build");
    public static final SystemProperty DISABLE_BRANCH_DETECTION = new SystemProperty(false, "atlassian.bamboo.branch.detection.disable");
    public static final BooleanSystemProperty DISABLE_TAG_DETECTION = new BooleanSystemProperty(false, false, "atlassian.bamboo.tag.detection.disable");
    public static final SystemProperty DISABLE_CLOSED_BRANCH_DETECTION = new SystemProperty(false, "atlassian.bamboo.closed.branch.detection.disable");
    public static final SystemProperty ATLASSIAN_DEV_MODE = new SystemProperty(false, "atlassian.dev.mode");
    public static final SystemProperty BAMBOO_REQUEST_PROFILING = new SystemProperty(false, "bamboo.request.profiling");
    public static final BooleanSystemProperty ALLOW_MUTATIVE_GET_IN_STRICT_XSRF_MODE = new BooleanSystemProperty(false, false, "bamboo.allowMutativeGetInStrictXsrfMode");
    public static final BooleanSystemProperty BAMBOO_MANAGED_JMS_SSL = new BooleanSystemProperty(false, false, "bamboo.manage.jms.ssl");
    public static final SystemProperty BAMBOO_JMS_SSL_CIPHER = new SystemProperty(false, "bamboo.jms.ssl.cipher");
    public static final SystemProperty BAMBOO_JMS_SSL_KEYSTORE = new SystemProperty(false, "bamboo.jms.ssl.keyStore");
    public static final SystemProperty BAMBOO_JMS_SSL_KEYSTORE_PASSWORD = new SystemProperty(false, "bamboo.jms.ssl.keyStorePassword");
    public static final SystemProperty BAMBOO_JMS_SSL_TRUSTSTORE = new SystemProperty(false, "bamboo.jms.ssl.trustStore");
    public static final SystemProperty BAMBOO_JMS_SSL_TRUSTSTORE_PASSWORD = new SystemProperty(false, "bamboo.jms.ssl.trustStorePassword");
    public static final IntegerSystemProperty EXPORT_WAIT_FOR_SERVER_PAUSE_SLEEP = new IntegerSystemProperty(false, Duration.ofMinutes(1L).toMillis(), "bamboo.export.wait.for.server.pause.sleep");
    public static final IntegerSystemProperty EXPORT_WAIT_FOR_SERVER_PAUSE_TIMEOUT = new IntegerSystemProperty(false, Duration.ofHours(1L).toMillis(), "bamboo.export.wait.for.server.pause.timeout");
    public static final SystemProperty EC2_AGENT_ENDPOINT = new SystemProperty(false, "bamboo.ec2.agent.endpoint");
    public static final SystemProperty CUSTOM_S3_ASSEMBLY_BUCKET = new SystemProperty(false, "bamboo.s3.agent.bucket");
    public static final SystemProperty FILE_UPLOAD_MAXIMUM_SIZE = new SystemProperty(false, "bamboo.file.upload.max.size");
    public static final BooleanSystemProperty FUSION_DEPLOYMENTS_SUPPORT_DISABLED = new BooleanSystemProperty(false, false, "bamboo.fusion.deployments.support.disabled");
    public static final BooleanSystemProperty REMOVE_LABELS_AND_PLANS_FOR_NON_PLAN_ADMIN = new BooleanSystemProperty(false, false, "bamboo.remove.labels.by.non.plan.admin");
    public static final BooleanSystemProperty DISABLE_STASH_BUILD_STATUS_UPDATES = new BooleanSystemProperty(false, false, "bamboo.stash.disable.build.status.updates");
    public static final BooleanSystemProperty DISABLE_STASH_DEPLOYMENT_UPDATES = new BooleanSystemProperty(false, false, "bamboo.stash.disable.deployment.updates");
    public static final BooleanSystemProperty DISABLE_STASH_EXTENDED_BUILD_STATUS_UPDATES = new BooleanSystemProperty(false, false, "bamboo.stash.disable.extended.build.status.updates");
    public static final BooleanSystemProperty ENFORCE_POLLING_BRANCH_DETECTION_EVEN_WHEN_REPO_CAN_PUSH_IT = new BooleanSystemProperty(false, false, "bamboo.stash.enforce.polling.branches");
    public static final IntegerSystemProperty STASH_REPOSITORY_TRIGGER_POLLING_INTERVAL = new IntegerSystemProperty(false, 0L, "bamboo.stash.repository.trigger.polling.interval");
    public static final BooleanSystemProperty DISABLE_STASH_POLLING = new BooleanSystemProperty(false, false, "bamboo.disable.stash.polling");
    public static final BooleanSystemProperty DISABLE_STASH_STATE_CHECK = new BooleanSystemProperty(false, false, "bamboo.disable.stash.state.check");
    public static final BooleanSystemProperty CREATE_BITBUCKET_SSH_ALLOWLIST_RECORDS_AUTOMATICALLY = new BooleanSystemProperty(false, true, "bamboo.stash.create.ssh.allow.list.records.automatically");
    public static final BooleanSystemProperty AGENT_QUEUE_OFFLOADING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.agent.queue.offloading.enabled");
    public static final IntegerSystemProperty EPHEMERAL_AGENTS_LAUNCH_RETRIES_NUMBER = new IntegerSystemProperty(false, 9L, "bamboo.agent.ephemeral.launch.retries");
    public static final IntegerSystemProperty EPHEMERAL_AGENTS_LAUNCH_RETRIES_QUEUE_SIZE = new IntegerSystemProperty(false, 1000L, "bamboo.agent.ephemeral.launch.retries.queue.size");
    public static final IntegerSystemProperty EPHEMERAL_AGENTS_LAUNCH_RETRIES_INITIAL_DELAY = new IntegerSystemProperty(false, 60L, "bamboo.agent.ephemeral.launch.retries.initial.delay");
    public static final IntegerSystemProperty EPHEMERAL_AGENTS_LAUNCH_RETRIES_DELAY = new IntegerSystemProperty(false, 10L, "bamboo.agent.ephemeral.launch.retries.delay");
    public static final IntegerSystemProperty EPHEMERAL_AGENTS_LOG_SIZE = new IntegerSystemProperty(false, 40L, "bamboo.agent.ephemeral.log.size");
    public static final IntegerSystemProperty EPHEMERAL_POD_DELETION_BATCH_SIZE = new IntegerSystemProperty(false, 5L, "bamboo.agent.ephemeral.deletion.batch.size");
    public static final IntegerSystemProperty EPHEMERAL_KUBERNETES_EXECUTION_TIMEOUT = new IntegerSystemProperty(false, 60L, "bamboo.agent.ephemeral.kubernetes.execution.timeout");
    public static final IntegerSystemProperty EPHEMERAL_KUBERNETES_IDLE_TIMEOUT = new IntegerSystemProperty(false, 60L, "bamboo.agent.ephemeral.kubernetes.idle.timeout");
    public static final BooleanSystemProperty ENABLE_REMOTE_AGENTS_SHELL = new BooleanSystemProperty(false, false, "bamboo.enable.remote.agent.shell");
    public static final BooleanSystemProperty SKIP_BOOT_DELEGATION_OVERRIDES = new BooleanSystemProperty(false, false, "bamboo.skip.boot.delegation.override");
    public static final BooleanSystemProperty ENABLE_XML_FACTORY_OVERRIDE = new BooleanSystemProperty(false, false, "bamboo.enable.xml.factory.override");
    public static final IntegerSystemProperty MAX_CONCURRENT_EXPENSIVE_MESSAGES = new IntegerSystemProperty(false, 1L, "bamboo.max.concurrent.expensive.messages");
    public static final SystemProperty BRANCH_EXPIRY_SCHEDULED_TIME = new SystemProperty(false, "bamboo.branch.expiry.schedule");
    public static final IntegerSystemProperty BAMBOO_BUILD_EXPIRY_BATCH_SIZE = new IntegerSystemProperty(false, 500L, "bamboo.build.expiry.batch.size");
    public static final IntegerSystemProperty BAMBOO_BUILD_EXPIRY_BATCH_INTERVAL_MILLISECONDS = new IntegerSystemProperty(false, 0L, "bamboo.build.expiry.batch.interval.milliseconds");
    public static final IntegerSystemProperty BAMBOO_BUILD_EXPIRY_TRANSACTION_TIME_LIMIT_SECONDS = new IntegerSystemProperty(false, 1800L, "bamboo.build.expiry.transaction.time.limit.seconds");
    public static final BooleanSystemProperty PERSIST_RUNTIME_STATE = new BooleanSystemProperty(false, true, "bamboo.darkfeature.persist.runtime.state");
    public static final BooleanSystemProperty BAMBOO_IGNORE_SERVER_STATE_ON_RESTART = new BooleanSystemProperty(false, false, "bamboo.ignore.server.state.on.restart");
    public static final SystemProperty BROKER_KAHA_PREALLOCATION_STRATEGY = new SystemProperty(false, "bamboo.broker.kaha.preallocationStrategy");
    public static final SystemProperty BROKER_KAHA_JOURNAL_DISK_SYNC_STRATEGY = new SystemProperty(false, "bamboo.broker.kaha.journalDiskSyncStrategy");
    public static final IntegerSystemProperty BAMBOO_ACTIVE_MQ_MEMORY_USAGE_LIMIT_MB = new IntegerSystemProperty(false, 512L, "bamboo.active.mq.memory.usage.limit.mb");
    public static final BooleanSystemProperty GLOBAL_REPOSITORY_DASHBOARD = new BooleanSystemProperty(false, true, "bamboo.darkfeature.repository.dashboard");
    public static final BooleanSystemProperty DISABLE_MAIN_DASHBOARD_OPTIMIZATION = new BooleanSystemProperty(false, false, "bamboo.dashboard.disable.optimization");
    public static final IntegerSystemProperty MAIL_QUEUE_SIZE = new IntegerSystemProperty(false, 1000L, "bamboo.mail.queue.size");
    public static final SystemProperty GRAVATAR_BASE_URL = new SystemProperty(false, "aid.avatar.url");
    public static final SystemProperty PLAN_DIRECTORY_INFO_REST = new SystemProperty(false, "bamboo.plan.directory.info.rest");
    public static final SystemProperty BAMBOO_INSTANCE_SPECIFIC_DATA_LOCATIONS = new SystemProperty(false, "bamboo.instance.specific.data.locations");
    public static final BooleanSystemProperty GIT_PASSWORD_USE_CREDENTIALS_FILE = new BooleanSystemProperty(false, true, "bamboo.git.password.use.credentials.file");
    public static final SystemProperty ELASTIC_AGENT_INSTANCE_NAME = new SystemProperty(false, "elastic.agent.instance.name");
    public static final BooleanSystemProperty CRYPTO_TRUST_SVN_SSH_ALL = new BooleanSystemProperty(false, false, "bamboo.crypto.trust.svn.ssh.all");
    public static final BooleanSystemProperty DISABLE_SERIALIZATION_SECURITY = new BooleanSystemProperty(false, false, "bamboo.security.serialization.disable");
    public static final IntegerSystemProperty MAX_PENDING_TEST_CASE_EVICTIONS = new IntegerSystemProperty(false, 1000L, "bamboo.max.pending.test.case.evictions");
    public static final SystemProperty ORPHANED_TEST_CASE_CRON_SCHEDULE = new SystemProperty(false, "bamboo.orphaned.test.case.cron");
    public static SystemProperty ORPHANED_BUILD_MONITOR_JOB_SCHEDULER_REACTION_DELAY_MULTIPLIER = new SystemProperty(false, "bamboo.orphaned.build.monitor.reaction.delay.multiplier");
    public static final BooleanSystemProperty SKIP_MSSQL_CONFIG_VALIDATION = new BooleanSystemProperty(false, false, "bamboo.skip.mssql.config.validation");
    public static final BooleanSystemProperty HIDE_PORTED_LEGACY_REPOSITORIES = new BooleanSystemProperty(false, true, "hide.ported.legacy.repositories");
    public static final BooleanSystemProperty DISABLE_ALL_DARK_FEATURES = new BooleanSystemProperty(false, false, "atlassian.darkfeature.disabled");
    public static final BooleanSystemProperty ALLOW_URL_PARAMETERS_LOGIN = new BooleanSystemProperty(false, false, "bamboo.allow.url.parameters.login");
    public static final BooleanSystemProperty DISABLE_ENCRYPTION = new BooleanSystemProperty(false, false, "bamboo.security.encryption.disable");
    public static final BooleanSystemProperty IGNORE_DECRYPTION_ERRORS = new BooleanSystemProperty(false, false, "bamboo.security.decryption.ignore.errors");
    public static final IntegerSystemProperty REPOSITORY_STORED_SPECS_TIMEOUT_SECONDS = new IntegerSystemProperty(false, 60L, "bamboo.repository.stored.specs.timeout_seconds");
    public static final IntegerSystemProperty REPOSITORY_STORED_SPECS_THREADS = new IntegerSystemProperty(false, 3L, "bamboo.repository.stored.specs.threads");
    public static final BooleanSystemProperty REPOSITORY_STORED_SPECS_SECURITY_MANAGER_ENABLED = new BooleanSystemProperty(false, true, "bamboo.repository.stored.specs.security.manager.enabled");
    public static final BooleanSystemProperty REPOSITORY_STORED_SPECS_POM_SANITIZATION_ENABLED = new BooleanSystemProperty(false, true, "bamboo.repository.stored.specs.pom.sanitization.enabled");
    public static final SystemProperty REPOSITORY_STORED_SPECS_MAVEN_COMPILER_VERSION = new SystemProperty(false, "bamboo.repository.stored.specs.maven.compiler.version");
    public static final BooleanSystemProperty CLEAN_TEMP_AT_START_ENABLED = new BooleanSystemProperty(false, false, "bamboo.clean.temp.enabled");
    public static final IntegerSystemProperty CHANGE_DETECTION_CACHE_TTL_SECONDS = new IntegerSystemProperty(false, 15L, "bamboo.change.detection.cache.ttl.seconds");
    public static final IntegerSystemProperty PULL_REQUEST_DETECTION_THREAD_COUNT = new IntegerSystemProperty(false, 3L, "bamboo.pull.request.detection.threads.count");
    public static final SystemProperty ORPHANED_PULL_REQUESTS_CLEANUP_SCHEDULE = new SystemProperty(false, "bamboo.pull.request.orphaned.cleanup.cron");
    public static final IntegerSystemProperty ORPHANED_PULL_REQUEST_INACTIVITY_DAYS = new IntegerSystemProperty(false, 7L, "bamboo.pull.request.orphaned.cleanup.inactivity.days");
    public static final IntegerSystemProperty PULL_REQUEST_POLLING_INTERVAL = new IntegerSystemProperty(false, 0L, "bamboo.pull.request.polling.interval.seconds");
    public static final IntegerSystemProperty PULL_REQUEST_CACHE_TTL = new IntegerSystemProperty(false, 60L, "bamboo.pull.request.cache.ttl.seconds");
    public static final BooleanSystemProperty JUNIT_PARSER_IGNORE_NAMED_INNER_CLASSES = new BooleanSystemProperty(false, false, "bamboo.junit.parser.ignore.named.inner.classes");
    public static final IntegerSystemProperty DEFAULT_TIMEOUT_FOR_HTTP_CLIENT = new IntegerSystemProperty(false, 5000L, "bamboo.rest.utils.defaultTimeout");
    @Deprecated
    public static final BooleanSystemProperty DISABLE_X_CONTENT_TYPE_OPTIONS_NOSNIFF = new BooleanSystemProperty(false, false, "bamboo.security.x.content.type.options.nosniff.disable");
    public static final SystemProperty TEXT_PLAIN_MIME_DEFAULT_ENCODING = new SystemProperty(false, "bamboo.text.plain.mime.encoding");
    public static final BooleanSystemProperty SKIP_DB_VERSION_CHECKS = new BooleanSystemProperty(false, false, "bamboo.skip.db.version.checks");
    public static final BooleanSystemProperty CHECK_MYSQL_VER_ON_UPGRADE = new BooleanSystemProperty(false, true, "bamboo.upgrade.fail.if.mysql.unsupported");
    public static final BooleanSystemProperty CHECK_JAVA_VERSION_ON_UPGRADE = new BooleanSystemProperty(false, true, "bamboo.upgrade.fail.if.java.unsupported");
    public static final BooleanSystemProperty SETUP_RSS_IN_DOCKER = new BooleanSystemProperty(false, true, "bamboo.setup.rss.in.docker");
    public static final BooleanSystemProperty SKIP_RSS_OPTIMISATION = new BooleanSystemProperty(false, false, "bamboo.rss.skip.optimisation");
    public static final BooleanSystemProperty DOCKER_PIPELINES_DISABLED = new BooleanSystemProperty(false, false, "bamboo.docker.pipelines.disable");
    public static final BooleanSystemProperty RSS_COMMIT_LEVEL_COMMENT_DISABLED = new BooleanSystemProperty(false, false, "bamboo.repository.stored.specs.commit.comment.disabled");
    public static final BooleanSystemProperty LOGS_AS_ARTIFACTS_ENABLED = new BooleanSystemProperty(false, true, "bamboo.logs.as.artifacts");
    public static final SystemProperty VARIABLE_UPGRADE_SCHEDULE_CRON = new SystemProperty(false, "bamboo.variable.upgrade.schedule");
    public static final int VARIABLE_UPGRADE_DEFAULT_BATCH_SIZE = 300;
    public static final IntegerSystemProperty VARIABLE_UPGRADE_BATCH_SIZE = new IntegerSystemProperty(false, 300L, "bamboo.variable.upgrade.batch.size");
    public static final IntegerSystemProperty BUILD_WARNINGS_MAXIMUM_COUNT_PER_BUILD = new IntegerSystemProperty(false, -1L, "bamboo.build.warnings.maximum.count");
    public static final IntegerSystemProperty BUILD_WARNINGS_THREAD_COUNT = new IntegerSystemProperty(false, 2L, "bamboo.build.warnings.thread.count");
    public static final IntegerSystemProperty BUILD_WARNINGS_QUEUE_MAX_SIZE = new IntegerSystemProperty(false, 200L, "bamboo.build.warnings.queue.max.size");
    public static final BooleanSystemProperty RSS_POLLING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.rss.polling.enabled");
    public static final IntegerSystemProperty CROWD_DELETED_ENTITY_LISTENER_THREADS = new IntegerSystemProperty(false, 2L, "bamboo.crowd.deleted.entity.listener.threads");
    public static final IntegerSystemProperty CROWD_DELETED_ENTITY_TIMEOUT_DAYS = new IntegerSystemProperty(false, 7L, "bamboo.crowd.deleted.entity.timeout.days");
    public static final IntegerSystemProperty CROWD_DELETED_ENTITY_CLEANUP_HOUR = new IntegerSystemProperty(false, 4L, "bamboo.crowd.deleted.entity.cleanup.hour");
    public static final BooleanSystemProperty PERFORMANCE_DATA_GATHERING_ENABLED = new BooleanSystemProperty(false, true, "bamboo.performance.data.gathering.enabled");
    public static final BooleanSystemProperty PERFORMANCE_DATA_TEST_GATHERING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.test.performance.data.gathering.enabled");
    public static final IntegerSystemProperty PERFORMANCE_DATA_DISPATCH_HOUR = new IntegerSystemProperty(false, 2L, "bamboo.performance.data.dispatch.hour");
    public static final IntegerSystemProperty STALE_AVATARS_REMOVAL_HOUR = new IntegerSystemProperty(false, 5L, "bamboo.performance.data.dispatch.hour");
    public static final IntegerSystemProperty SSH_PROXY_CLIENT_AUTH_TIMEOUT = new IntegerSystemProperty(false, 2L, "bamboo.ssh.proxy.client.auth.timeout");
    public static final IntegerSystemProperty SSH_PROXY_CLIENT_IDLE_TIMEOUT = new IntegerSystemProperty(false, 2L, "bamboo.ssh.proxy.client.idle.timeout");
    public static final IntegerSystemProperty SSH_PROXY_SERVER_IDLE_TIMEOUT = new IntegerSystemProperty(false, 10L, "bamboo.ssh.proxy.server.idle.timeout");
    public static final IntegerSystemProperty SSH_PROXY_SERVER_READ_TIMEOUT = new IntegerSystemProperty(false, 11L, "bamboo.ssh.proxy.server.read.timeout");
    public static final BooleanSystemProperty EC_UPGRADE_TEST_CONNECTION_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec.upgrade.test.connection.enabled");
    public static final BooleanSystemProperty DISABLE_REMOTE_TRIGGER_PROXY_VALIDATION = new BooleanSystemProperty(false, false, "bamboo.remote.trigger.proxy.validation.disabled");
    public static final IntegerSystemProperty SPECS_YAML_INCLUDE_MAX_DEPTH = new IntegerSystemProperty(false, 10L, "bamboo.specs.yaml.include.max.depth");
    public static final SystemProperty JMS_STORE_DIRECTORY = new SystemProperty(false, "bamboo.jms.store.directory");
    public static final IntegerSystemProperty MAX_TOKENS_PER_USER = new IntegerSystemProperty(false, 100L, "bamboo.access.token.user.max");
    public static final BooleanSystemProperty DISABLE_RESULTS_CLEANUP_ON_STARTUP = new BooleanSystemProperty(false, false, "bamboo.disable.results.cleanup.on.startup");
    public static final BooleanSystemProperty SPECS_FOR_BRANCHES_ENABLED = new BooleanSystemProperty(false, true, "bamboo.specs.for.branches.enabled");
    public static final BooleanSystemProperty NOTIFICATION_DISABLED = new BooleanSystemProperty(false, false, "atlassian.mail.senddisabled");
    public static final BooleanSystemProperty SHOW_STACK_TRACES_ON_500 = new BooleanSystemProperty(false, true, "bamboo.show.internal.server.error.stacks");
    public static final IntegerSystemProperty OSGI_SERVICE_INVOCATION_TIMEOUT = new IntegerSystemProperty(false, 10000L, "bamboo.osgi.service.invocation.timeout");
    public static final SystemProperty ORPHANED_SPECS_STATES_CLEANUP_SCHEDULE = new SystemProperty(false, "bamboo.orphaned.specs.states.cleanup.cron");
    public static final IntegerSystemProperty SPECS_MAX_ALIASES_FOR_COLLECTIONS = new IntegerSystemProperty(false, 1500L, "bamboo.specs.max.aliases.for.collections");
    public static final IntegerSystemProperty SPECS_CODE_POINTS_LIMIT_PROPERTY = new IntegerSystemProperty(false, 0x600000L, "bamboo.specs.code.point.limit");
    public static final BooleanSystemProperty GLOBAL_EXPORT_TO_SPECS_ENABLED = new BooleanSystemProperty(false, false, "global.export.to.specs.enabled");
    public static BooleanSystemProperty REPOSITORY_STORED_SPECS_DETECTION_DISABLED = new BooleanSystemProperty(false, false, "bamboo.repository.stored.specs.detection.disabled");
    public static final BooleanSystemProperty NATIVE_GIT_FOLDER_CLEARING_DISABLED = new BooleanSystemProperty(false, true, "bamboo.native.git.folder.clearing.disabled");
    public static final IntegerSystemProperty WEBHOOK_MAX_QUEUE_SIZE = new IntegerSystemProperty(false, 1024L, "bamboo.webhook.queue.size");
    public static final IntegerSystemProperty WEBHOOK_TIMEOUT = new IntegerSystemProperty(false, 10000L, "bamboo.webhook.timeout");
    public static final IntegerSystemProperty WEBHOOK_MAX_RETRIES = new IntegerSystemProperty(false, 3L, "bamboo.webhook.max.retries");
    public static final IntegerSystemProperty WEBHOOK_THREAD_COUNT = new IntegerSystemProperty(false, 2L, "bamboo.webhook.threads.count");
    public static final IntegerSystemProperty REMOTE_BROADCAST_DOWNTIME_INCREMENT_SECONDS = new IntegerSystemProperty(false, 30L, "bamboo.remote.broadcast.downtime.increment.second");
    public static final IntegerSystemProperty REMOTE_BROADCAST_DOWNTIME_MAX_MULTIPLIER = new IntegerSystemProperty(false, 5L, "bamboo.remote.broadcast.downtime.max.multiplier");
    public static final IntegerSystemProperty REMOTE_AGENT_ASYNCH_DISPATCH_THREADPOOL_SIZE = new IntegerSystemProperty(false, 0L, "bamboo.remote.asynch.dispatch.threadpool.size");
    public static final IntegerSystemProperty IMPORT_REPORT_PROGRESS_STEP_PROPERTY = new IntegerSystemProperty(false, 1000L, "bamboo.import.display.progress.step");
    public static final BooleanSystemProperty AUDIT_LOG_FOR_RSS_UPDATES_DISABLED = new BooleanSystemProperty(false, true, "bamboo.rss.audit.logs.disabled");
    public static final BooleanSystemProperty NODE_ALIVE_WATCHDOG_ENABLED = new BooleanSystemProperty(false, true, "bamboo.node.alive.watchdog.enabled");
    public static final IntegerSystemProperty NODE_ALIVE_WATCHDOG_INTERVAL_IN_SECONDS = new IntegerSystemProperty(false, 20L, "bamboo.node.alive.watchdog.interval.seconds");
    public static final IntegerSystemProperty CLUSTER_HEARTBEAT_ALIVE_TIMEOUT_IN_SECONDS = new IntegerSystemProperty(false, 300L, "bamboo.cluster.heartbeat.alive.timeout.seconds");
    public static final IntegerSystemProperty CLUSTER_HEARTBEAT_JOB_INTERVAL_IN_SECONDS = new IntegerSystemProperty(false, 30L, "bamboo.cluster.heartbeat.job.interval.seconds");
    public static final BooleanSystemProperty CLUSTER_CONNECT_SECONDARY_ONLY_IF_GRPC_COMMUNICATION_IS_WORKING = new BooleanSystemProperty(false, true, "bamboo.cluster.connect.secondary.only.if.grpc.communication.is.working");
    public static final SystemProperty OPTIMISTIC_LOCKING_MODE = new SystemProperty(false, "bamboo.optimistic.locking.mode");
    public static final BooleanSystemProperty HTTP_CACHE_DISABLED = new BooleanSystemProperty(false, false, "atlassian.disable.caches");
    public static final BooleanSystemProperty CUSTOM_LUCENE_INDICES_ALLOWED = new BooleanSystemProperty(false, false, "bamboo.custom.lucene.indices.allowed");
    public static final BooleanSystemProperty FORCE_PULL_SPECS_RUNNER_IMAGE = new BooleanSystemProperty(false, false, "bamboo.repository.stored.specs.image.pull.force");
    public static final BooleanSystemProperty SKIP_LOCAL_HOME_LOCK = new BooleanSystemProperty(false, false, "bamboo.skip.local.home.lock");
    public static final BooleanSystemProperty RENAME_USER_IN_HISTORICAL_DATA = new BooleanSystemProperty(false, false, "bamboo.rename.user.in.historical.data");
    public static final BooleanSystemProperty VERIFY_INDEX_ON_STARTUP = new BooleanSystemProperty(false, true, "bamboo.verify.index.on.startup");
    public static final IntegerSystemProperty MAX_PRIMARY_LOCK_ACQUISITION_ERRORS = new IntegerSystemProperty(false, 10L, "bamboo.max.primary.lock.acquisition.errors");
    public static final BooleanSystemProperty SKIP_SERVER_SIDE_VCS_MERGE = new BooleanSystemProperty(false, false, "bamboo.skip.server.side.vcs.merge");
    public static final IntegerSystemProperty PRIMARY_CLUSTER_LOCK_TIMEOUT_SECONDS = new IntegerSystemProperty(false, 60L, "bamboo.primary.node.lock.timeout.seconds");
    public static final IntegerSystemProperty PLUGIN_SYSTEM_LOCK_TIMEOUT_SECONDS = new IntegerSystemProperty(false, 120L, "bamboo.plugin.system.lock.timeout.seconds");
    public static final BooleanSystemProperty ARTIFACT_DOWNLOAD_IGNORES_SUCCESS_RESULT_REQUIREMENT = new BooleanSystemProperty(false, true, "bamboo.task.artifact.download.ignores.success.result.when.conditional");
    public static final IntegerSystemProperty BUILD_RESULT_RETRY_DELAY_SECONDS = new IntegerSystemProperty(false, 5L, "bamboo.agent.result.retry.delay");
    public static final SystemProperty ARTIFACT_TEMP_FOLDER = new SystemProperty(false, "bamboo.artifact.temp.path");
    public static final BooleanSystemProperty FETCHING_LFS_FILES_ON_SERVER_ENABLED = new BooleanSystemProperty(false, false, "bamboo.fetching.lfs.files.enabled");
    public static final IntegerSystemProperty JIRA_ISSUE_UPDATE_INTERVAL_SECONDS = new IntegerSystemProperty(false, 20L, "bamboo.jira.update.interval.seconds");
    public static final IntegerSystemProperty JIRA_ISSUE_UPDATE_MAX_DELAY_MULTIPLIER = new IntegerSystemProperty(false, 5L, "bamboo.jira.update.max.delay.multiplier");
    public static final BooleanSystemProperty DELETE_PLAN_BRANCH_WHEN_BRANCH_REMOVED_FROM_VCS = new BooleanSystemProperty(false, false, "bamboo.plan.branch.delete.when.removed.from.vcs");
    public static final BooleanSystemProperty DELETE_PLAN_BRANCH_WHEN_BRANCH_IS_INACTIVE_IN_VCS = new BooleanSystemProperty(false, false, "bamboo.plan.branch.delete.when.inactive.in.vcs");
    public static final BooleanSystemProperty SKIP_TEST_HISTORY_FEATURE_ENABLED = new BooleanSystemProperty(false, true, "bamboo.no.test.history.feature.enabled");
    public static final IntegerSystemProperty ARTIFACT_COPY_BUFFER_SIZE = new IntegerSystemProperty(false, 0x100000L, "bamboo.artifact.copy.buffer.size");
    public static final IntegerSystemProperty ARTIFACT_COMPRESSION_BUFFER_SIZE = new IntegerSystemProperty(false, 0x100000L, "bamboo.artifact.archive.buffer.size");
    public static final IntegerSystemProperty BRANCH_EVENT_HANDLERS_THREAD_POOL_SIZE = new IntegerSystemProperty(false, 4L, "bamboo.branch.event.handlers.thread.pool.size");
    public static final BooleanSystemProperty ENABLE_ROBOTS_TXT = new BooleanSystemProperty(false, false, "bamboo.enable.robots.txt");
    public static final BooleanSystemProperty BAMBOO_GRPC_AUTHENTICATION_ENABLED = new BooleanSystemProperty(false, true, "bamboo.grpc.authentication.enabled");
    public static final BooleanSystemProperty BAMBOO_GRPC_AUTHENTICATION_SAVE_CLIENT_CERTIFICATES_TO_DISK = new BooleanSystemProperty(false, false, "bamboo.grpc.authentication.save.client.certificates.to.disk");
    public static final DefaultStringSystemProperty BAMBOO_GRPC_AUTHENTICATION_ROOT_CA_FILENAME = new DefaultStringSystemProperty(false, "custom_ca.pem", new String[]{"bamboo.grpc.authentication.root.ca.filename"});
    public static final DefaultStringSystemProperty BAMBOO_GRPC_AUTHENTICATION_ROOT_CA_KEY_PASSPHRASE = new DefaultStringSystemProperty(false, "", new String[]{"bamboo.grpc.authentication.root.ca.key.passphrase"});
    public static final SystemProperty BAMBOO_GRPC_AUTHENTICATION_ROOT_CA_CIPHER = new SystemProperty(false, "bamboo.grpc.authentication.root.ca.cipher");
    public static final IntegerSystemProperty GRPC_CERTIFICATE_VALIDITY_DURATION = new IntegerSystemProperty(false, 20L, "bamboo.grpc.authentication.certificate.validity.duration");
    public static final BooleanSystemProperty BAMBOO_ENABLE_GRPC_VIA_PROXY = new BooleanSystemProperty(false, false, "bamboo.enable.grpc.via.proxy");
    public static final IntegerSystemProperty GRPC_SERVER_THREADS_NUMBER = new IntegerSystemProperty(false, 6L, "bamboo.grpc.server.threads.number");
    public static final IntegerSystemProperty CROSS_NODES_EVENTS_GRPC_CLIENT_THREADS_NUMBER = new IntegerSystemProperty(false, 6L, "bamboo.cross.nodes.events.grpc.client.threads.number");
    public static final IntegerSystemProperty PEER_TO_PEER_GRPC_CLIENT_THREADS_NUMBER = new IntegerSystemProperty(false, 2L, "bamboo.peer.to.peer.grpc.client.threads.number");
    public static final IntegerSystemProperty PER_NODE_QUEUE_DISPATCHERS_THREADS_NUMBER = new IntegerSystemProperty(false, 4L, "bamboo.per.node.dispatchers.threads.number");
    public static final IntegerSystemProperty NUMBER_OF_PHYSICAL_QUEUES_UNDER_PER_NODE_QUEUE = new IntegerSystemProperty(false, 8L, "bamboo.physical.queues.per.node.queue");
    public static final IntegerSystemProperty PER_NODE_PHYSICAL_QUEUE_MAX_SIZE = new IntegerSystemProperty(false, -1L, "bamboo.per.node.physical.queue.max.size");
    public static final IntegerSystemProperty PER_NODE_PHYSICAL_QUEUE_MAX_USED_BYTES = new IntegerSystemProperty(false, -1L, "bamboo.per.node.physical.queue.max.used.bytes");
    public static final IntegerSystemProperty PER_NODE_QUEUE_STATS_LOGGING_INTERVAL_MINUTES = new IntegerSystemProperty(false, 10L, "bamboo.per.node.queue.stats.logging.interval.minutes");
    public static final IntegerSystemProperty BAMBOO_CLUSTER_INFO_CACHE_TTL_SECONDS = new IntegerSystemProperty(false, 120L, "bamboo.cluster.info.cache.ttl");
    public static final BooleanSystemProperty UPM_PLUGIN_UPLOAD_ENABLED = new BooleanSystemProperty(false, false, "upm.plugin.upload.enabled");
    public static final BooleanSystemProperty APPLINKS_ALL_HOSTS_ENABLED = new BooleanSystemProperty(false, false, "applinks.allow.all.hosts");
    public static final BooleanSystemProperty LOG_MESSAGE_ESCAPE_ENABLED = new BooleanSystemProperty(false, true, "bamboo.log.message.escape.enabled");
    public static IntegerSystemProperty LOG_MESSAGE_MAX_LENGTH = new IntegerSystemProperty(false, 10000L, "bamboo.log.message.max.length");
    public static final BooleanSystemProperty ALLOW_FREEMARKER_TEMPLATES_AT_WEBHOOK_PAYLOAD = new BooleanSystemProperty(false, false, "bamboo.security.allow.freemarker.at.webhook.payload");
    public static final BooleanSystemProperty DISABLE_CHECK_EXISTING_DB_DATA_IN_DEV_MODE = new BooleanSystemProperty(false, false, "bamboo.setup.dev.mode.check.db.disable");
    public static final SystemProperty SYSTEM_INFO_SCHEDULER_CRON = new SystemProperty(false, "bamboo.system.info.cron");
    public static final BooleanSystemProperty GITHUB_BUILD_STATUS_HANDLING_ENABLED = new BooleanSystemProperty(false, true, "bamboo.github.build.status.handling.enabled");
    @Deprecated
    public static final BooleanSystemProperty J_GIT_DISABLED = new BooleanSystemProperty(false, false, "bamboo.jgit.disabled");
    public static final BooleanSystemProperty DEFAULT_ENDPOINT_TO_LICENSED_ACCESS = new BooleanSystemProperty(false, true, "bamboo.security.endpoint.annotation.default.to.licensed.access");
    public static BooleanSystemProperty WEBSUDO_DISABLED = new BooleanSystemProperty(false, false, "bamboo.websudo.disabled");
    public static IntegerSystemProperty WEBSUDO_SESSION_DURATION = new IntegerSystemProperty(false, 600L, "bamboo.websudo.session.timeout.seconds");
    public static IntegerSystemProperty WEBSUDO_SESSION_DURATION_TOLERANCE = new IntegerSystemProperty(false, 30L, "bamboo.websudo.session.tolerance.seconds");
    public static final BooleanSystemProperty ATLASSIAN_AUTHENTICATION_BAMBOO_LEGACY_MODE = new BooleanSystemProperty(false, false, "atlassian.authentication.bamboo.legacy.mode");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_DISABLED = new BooleanSystemProperty(false, false, "bamboo.http.header.security.disabled");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_HSTS_DISABLED = new BooleanSystemProperty(false, false, "bamboo.http.header.security.hsts.disabled");
    public static final IntegerSystemProperty HTTP_HEADER_SECURITY_HSTS_MAX_AGE = new IntegerSystemProperty(false, 31536000L, "bamboo.http.header.security.hsts.max.age");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_HSTS_PRELOAD_ENABLED = new BooleanSystemProperty(false, false, "bamboo.http.header.security.hsts.preload.enabled");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_HSTS_INCLUDE_SUB_DOMAINS = new BooleanSystemProperty(false, false, "bamboo.http.header.security.hsts.include.subdomains");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_ANTI_CLICKJACKING_PROTECTION_DISABLED = new BooleanSystemProperty(false, false, "bamboo.http.header.security.anti.clickjacking.disabled");
    public static final SystemProperty HTTP_HEADER_SECURITY_ANTI_CLICKJACKING_X_FRAME_OPTIONS_VALUE = new SystemProperty(false, "bamboo.http.header.security.anti.clickjacking.x_frame_options");
    public static final SystemProperty HTTP_HEADER_SECURITY_CSP = new SystemProperty(false, "bamboo.http.header.security.csp");
    public static final SystemProperty HTTP_HEADER_SECURITY_REFERRER_POLICY = new SystemProperty(false, "bamboo.http.header.security.referrer.policy");
    public static final SystemProperty HTTP_HEADER_SECURITY_PERMISSIONS_POLICY = new SystemProperty(false, "bamboo.http.header.security.permissions.policy");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_XSS_PROTECTION_DISABLED = new BooleanSystemProperty(false, false, "bamboo.http.header.security.xss.protection.disabled");
    public static final BooleanSystemProperty HTTP_HEADER_SECURITY_X_CONTENT_TYPE_OPTIONS_NOSNIFF_DISABLED = new BooleanSystemProperty(false, false, "bamboo.http.header.security.x_content_type_options.nosniff.disabled");

    public SystemProperty(boolean mandatory, String ... properties) {
        super(mandatory, properties);
    }

    @VisibleForTesting
    protected SystemProperty(String property, boolean mandatory, Logger log) {
        super(property, mandatory, log);
    }

    private static int getFilesystemTimestampResolution() {
        return SystemUtils.IS_OS_MAC ? 1000 : 100;
    }

    public static class BooleanSystemProperty
    extends AbstractSystemProperty {
        private final boolean defaultValue;

        public BooleanSystemProperty(boolean mandatory, boolean defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        public boolean getTypedValue() {
            String stringValue = this.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return BooleanUtils.toBoolean((String)stringValue);
        }

        public void setTypedValue(boolean value) {
            this.setValue(Boolean.toString(value));
        }
    }

    public static class IntegerSystemProperty
    extends AbstractSystemProperty {
        private final long defaultValue;

        public IntegerSystemProperty(boolean mandatory, long defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        public long getTypedValue() {
            String stringValue = this.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return Long.parseLong(stringValue);
        }
    }

    public static class DefaultStringSystemProperty
    extends AbstractSystemProperty {
        private final String defaultValue;

        public DefaultStringSystemProperty(boolean mandatory, String defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        @Override
        public String getValue() {
            String stringValue = super.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return stringValue;
        }
    }

    public static class UrlSystemProperty
    extends AbstractSystemProperty {
        public UrlSystemProperty(boolean mandatory, String ... properties) {
            super(mandatory, properties);
        }

        @Override
        @NotNull
        public String getValue(@NotNull String defaultValue) {
            return UrlUtils.correctlyFormatUrl(super.getValue(defaultValue));
        }
    }
}

