/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.StringOutputHandler;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Which {
    private static final Logger log = Logger.getLogger(Which.class);
    private static final String NEWLINE = String.format("%n", new Object[0]);

    private Which() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String execute(@NotNull String executableName) {
        StringOutputHandler stdout = new StringOutputHandler();
        StringOutputHandler stderr = new StringOutputHandler();
        if (SystemUtils.IS_OS_WINDOWS) {
            ExternalProcess externalProcess = new ExternalProcessBuilder().command(Arrays.asList("WHERE", executableName)).handlers((OutputHandler)stdout, (OutputHandler)stderr).build();
            try {
                String[] lines;
                externalProcess.execute();
                String output = stdout.getOutput();
                if (externalProcess.getHandler().getExitCode() != 0 || !StringUtils.isNotEmpty((CharSequence)output) || (lines = StringUtils.split((String)output, (String)NEWLINE)).length <= 0) return null;
                String string = StringUtils.strip((String)lines[0]);
                return string;
            }
            catch (Exception e) {
                log.error((Object)("Could not execute `where " + executableName + "`: " + String.valueOf(stderr)), (Throwable)e);
                return null;
            }
            finally {
                externalProcess.cancel();
            }
        }
        ExternalProcess externalProcess = new ExternalProcessBuilder().command(Arrays.asList("/usr/bin/which", executableName)).handlers((OutputHandler)stdout, (OutputHandler)stderr).build();
        try {
            externalProcess.execute();
            String output = stdout.getOutput();
            if (!StringUtils.isNotEmpty((CharSequence)output)) return null;
            String string = StringUtils.strip((String)output);
            return string;
        }
        catch (Exception e) {
            log.error((Object)("Could not execute `/usr/bin/which " + executableName + "`: " + String.valueOf(stderr)), (Throwable)e);
            return null;
        }
        finally {
            externalProcess.cancel();
        }
    }
}

