/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection.multimap;

import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.collection.multimap.ImmutableMultimap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ImmutableSetMultimap<K, V>
implements ImmutableMultimap<K, V> {
    private final Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    private ImmutableSetMultimap() {
    }

    public static <K, V> ImmutableSetMultimap<K, V> create() {
        return new ImmutableSetMultimap<K, V>();
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(Collection<Pair<K, V>> input) {
        ImmutableSetMultimap immutableSetMultimap = ImmutableSetMultimap.create();
        HashMap<Object, Set> groupedMap = new HashMap<Object, Set>();
        for (Pair<K, V> pair : input) {
            K key = pair.getFirst();
            V value = pair.getSecond();
            groupedMap.computeIfAbsent(key, k -> new HashSet()).add(value);
        }
        for (Map.Entry entry : groupedMap.entrySet()) {
            immutableSetMultimap.put(entry.getKey(), (Set)entry.getValue());
        }
        return immutableSetMultimap;
    }

    public static <K, V> ImmutableSetMultimap<K, V> of(K key, V value) {
        ImmutableSetMultimap<K, V> multimap = ImmutableSetMultimap.create();
        multimap.put(key, Collections.singleton(value));
        return multimap;
    }

    private void put(K key, Set<V> values) {
        this.map.put(key, Collections.unmodifiableSet(values));
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Collection<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.map.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(value -> new AbstractMap.SimpleEntry(entry.getKey(), value))).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.map.values().stream().mapToInt(Set::size).sum();
    }

    @Override
    public ImmutableMultimap<K, V> copy() {
        return ImmutableSetMultimap.of(this.entries().stream().map(entry -> Pair.make(entry.getKey(), entry.getValue())).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSetMultimap that = (ImmutableSetMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    @Override
    public ImmutableSetMultimap<V, K> inverse() {
        HashMap<Object, Set> tempMap = new HashMap<Object, Set>();
        for (Map.Entry<K, Set<V>> entry2 : this.map.entrySet()) {
            K originalKey = entry2.getKey();
            for (V value : entry2.getValue()) {
                tempMap.computeIfAbsent(value, k -> new HashSet()).add(originalKey);
            }
        }
        Set<Pair<K, V>> pairs = tempMap.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(value -> Pair.make(entry.getKey(), value))).collect(Collectors.toSet());
        return ImmutableSetMultimap.of(pairs);
    }
}

