/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection.multimap;

import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class LinkedSetMultimap<K, V>
implements Multimap<K, V> {
    private Map<K, LinkedHashSet<V>> map = new LinkedHashMap<K, LinkedHashSet<V>>();

    public static <K, V> LinkedSetMultimap<K, V> create() {
        return new LinkedSetMultimap<K, V>();
    }

    @Override
    public void put(K key, V value) {
        this.map.computeIfAbsent(key, k -> new LinkedHashSet()).add(value);
    }

    @Override
    public void putAll(K key, Collection<? extends V> values) {
        this.map.computeIfAbsent(key, k -> new LinkedHashSet()).addAll(values);
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.getOrDefault(key, new LinkedHashSet());
    }

    @Override
    public void remove(K key, V value) {
        if (this.map.containsKey(key)) {
            this.map.get(key).remove(value);
            if (this.map.get(key).isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    @Override
    public void removeAll(K key) {
        this.map.remove(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        LinkedHashSet<V> values = new LinkedHashSet<V>();
        for (LinkedHashSet<V> valueSet : this.map.values()) {
            values.addAll(valueSet);
        }
        return values;
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public LinkedSetMultimap<K, V> copy() {
        LinkedSetMultimap<K, V> copy = new LinkedSetMultimap<K, V>();
        for (Map.Entry<K, LinkedHashSet<V>> entry : this.map.entrySet()) {
            copy.map.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return copy;
    }

    @Override
    public int size() {
        int size = 0;
        for (LinkedHashSet<V> valueSet : this.map.values()) {
            size += valueSet.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        LinkedHashMap asMapView = new LinkedHashMap();
        for (Map.Entry<K, LinkedHashSet<V>> entry : this.map.entrySet()) {
            asMapView.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return asMapView;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, LinkedHashSet<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            for (Object value : entry.getValue()) {
                entries.add(new AbstractMap.SimpleEntry(key, value));
            }
        }
        return entries;
    }

    @Override
    public LinkedSetMultimap<V, K> inverse() {
        LinkedHashMap<Object, LinkedHashSet> tempMap = new LinkedHashMap<Object, LinkedHashSet>();
        for (Map.Entry<K, LinkedHashSet<V>> entry : this.map.entrySet()) {
            K originalKey = entry.getKey();
            for (Object value : entry.getValue()) {
                tempMap.computeIfAbsent(value, k -> new LinkedHashSet()).add(originalKey);
            }
        }
        LinkedSetMultimap inverseMap = new LinkedSetMultimap();
        for (Map.Entry entry : tempMap.entrySet()) {
            Object value = entry.getKey();
            for (Object originalKey : (LinkedHashSet)entry.getValue()) {
                inverseMap.put(value, originalKey);
            }
        }
        return inverseMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkedSetMultimap that = (LinkedSetMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

