/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection.multimap;

import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class SetMultimap<K, V>
implements Multimap<K, V> {
    private Map<K, Set<V>> map = new HashMap<K, Set<V>>();

    public static <K, V> SetMultimap<K, V> create() {
        return new SetMultimap<K, V>();
    }

    @Override
    public void put(K key, V value) {
        this.map.computeIfAbsent(key, k -> new HashSet()).add(value);
    }

    @Override
    public void putAll(K key, Collection<? extends V> values) {
        this.map.computeIfAbsent(key, k -> new HashSet()).addAll(values);
    }

    @Override
    public Set<V> get(K key) {
        return this.map.getOrDefault(key, new HashSet());
    }

    @Override
    public void remove(K key, V value) {
        if (this.map.containsKey(key)) {
            Set<V> values = this.map.get(key);
            values.remove(value);
            if (values.isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    @Override
    public void removeAll(K key) {
        this.map.remove(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsEntry(K key, V value) {
        return this.map.containsKey(key) && this.map.get(key).contains(value);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Collection<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
        for (Map.Entry<K, Set<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            for (V value : entry.getValue()) {
                entries.add(new AbstractMap.SimpleEntry<K, V>(key, value));
            }
        }
        return entries;
    }

    @Override
    public SetMultimap<K, V> copy() {
        SetMultimap<K, V> copy = new SetMultimap<K, V>();
        for (Map.Entry<K, Set<V>> entry : this.map.entrySet()) {
            copy.map.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return copy;
    }

    @Override
    public int size() {
        int size = 0;
        for (Set<V> valueSet : this.map.values()) {
            size += valueSet.size();
        }
        return size;
    }

    @Override
    public SetMultimap<V, K> inverse() {
        HashMap<Object, Set> tempMap = new HashMap<Object, Set>();
        for (Map.Entry<K, Set<V>> entry : this.map.entrySet()) {
            K originalKey = entry.getKey();
            for (V value : entry.getValue()) {
                tempMap.computeIfAbsent(value, k -> new HashSet()).add(originalKey);
            }
        }
        SetMultimap inverseMap = SetMultimap.create();
        for (Map.Entry entry : tempMap.entrySet()) {
            Object value = entry.getKey();
            for (Object originalKey : (Set)entry.getValue()) {
                inverseMap.put(value, originalKey);
            }
        }
        return inverseMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetMultimap that = (SetMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

