/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.artifact;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.utils.collection.multimap.ListMultimap;
import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApi
public class ArtifactMultimap
implements Multimap<String, Artifact> {
    private final FinalHashMap<String, FinalArrayList<Artifact>> map = new FinalHashMap();

    public static ArtifactMultimap create() {
        return new ArtifactMultimap();
    }

    public static ArtifactMultimap create(Multimap<String, Artifact> multimap) {
        ArtifactMultimap newListMultimap = new ArtifactMultimap();
        for (String key : multimap.keySet()) {
            Collection<Artifact> values = multimap.get(key);
            for (Artifact value : values) {
                newListMultimap.put(key, value);
            }
        }
        return newListMultimap;
    }

    public static ArtifactMultimap of(String key, Artifact value) {
        ArtifactMultimap listMultimap = ArtifactMultimap.create();
        listMultimap.put(key, value);
        return listMultimap;
    }

    @Override
    public void put(String key, Artifact value) {
        this.map.computeIfAbsent(key, k -> new FinalArrayList()).add(value);
    }

    @Override
    public void putAll(String key, Collection<? extends Artifact> values) {
        this.map.computeIfAbsent(key, k -> new FinalArrayList()).addAll(values);
    }

    @Override
    public List<Artifact> get(String key) {
        return this.map.getOrDefault(key, new FinalArrayList());
    }

    @Override
    public void remove(String key, Artifact value) {
        if (this.map.containsKey(key)) {
            ((FinalArrayList)this.map.get(key)).remove(value);
            if (((FinalArrayList)this.map.get(key)).isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    @Override
    public void removeAll(String key) {
        this.map.remove(key);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public Collection<Artifact> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public ArtifactMultimap copy() {
        ArtifactMultimap copy = new ArtifactMultimap();
        for (Map.Entry entry : this.map.entrySet()) {
            copy.map.put((String)entry.getKey(), new FinalArrayList((Collection)entry.getValue()));
        }
        return copy;
    }

    @Override
    public Collection<Map.Entry<String, Artifact>> entries() {
        ArrayList<Map.Entry<String, Artifact>> entries = new ArrayList<Map.Entry<String, Artifact>>();
        for (Map.Entry entry : this.map.entrySet()) {
            String key = (String)entry.getKey();
            for (Artifact value : (FinalArrayList)entry.getValue()) {
                entries.add(new AbstractMap.SimpleEntry<String, Artifact>(key, value));
            }
        }
        return entries;
    }

    @Override
    public int size() {
        int size = 0;
        for (List valueSet : this.map.values()) {
            size += valueSet.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<String, Collection<Artifact>> asMap() {
        return new HashMap<String, Collection<Artifact>>(this.map);
    }

    @Override
    public Multimap<Artifact, String> inverse() {
        HashMap<Artifact, List> tempMap = new HashMap<Artifact, List>();
        for (Map.Entry entry : this.map.entrySet()) {
            String originalKey = (String)entry.getKey();
            for (Artifact value : (FinalArrayList)entry.getValue()) {
                tempMap.computeIfAbsent(value, k -> new ArrayList()).add(originalKey);
            }
        }
        ListMultimap<Artifact, String> inverseMap = ListMultimap.create();
        for (Map.Entry entry : tempMap.entrySet()) {
            Artifact value = (Artifact)entry.getKey();
            for (String originalKey : (List)entry.getValue()) {
                inverseMap.put(value, originalKey);
            }
        }
        return inverseMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactMultimap that = (ArtifactMultimap)o;
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

