/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.timing;

import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.timing.AbstractBuildContextTimingPoint;
import com.atlassian.bamboo.v2.build.timing.AbstractBuildTimingPoint;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoint;
import java.util.Date;
import java.util.StringJoiner;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BuildTimingPoints
implements BuildTimingPoint {
    private static final Logger log = Logger.getLogger(BuildTimingPoints.class);

    private BuildTimingPoints() {
    }

    public static Queued queued(@NotNull BuildContext buildContext, @NotNull Date date) {
        return new Queued(buildContext, date);
    }

    public static AgentAssigned agentAssigned(@NotNull PlanResultKey planResultKey, @NotNull Date date, long agentId) {
        return new AgentAssigned(planResultKey, date, agentId);
    }

    public static SentToAgent sentToAgent(@NotNull PlanResultKey planResultKey, @NotNull Date date, long agentId) {
        return new SentToAgent(planResultKey, date, agentId);
    }

    @Deprecated
    public static VcsSyncStarted vcsSyncStarted(@NotNull PlanResultKey planResultKey, @NotNull Date date) {
        return new VcsSyncStarted(planResultKey, date);
    }

    public static ExecutionStarted executionStarted(@NotNull PlanResultKey planResultKey, @NotNull Date date) {
        return new ExecutionStarted(planResultKey, date);
    }

    public static ExecutionCancelled executionCancelled(@NotNull PlanResultKey planResultKey, @NotNull Date date, boolean buildActuallyCancelled) {
        return new ExecutionCancelled(planResultKey, date, buildActuallyCancelled);
    }

    public static ExecutionFinished executionFinished(@NotNull PlanResultKey planResultKey, @NotNull Date date) {
        return new ExecutionFinished(planResultKey, date);
    }

    public static class Queued
    extends AbstractBuildContextTimingPoint {
        public Queued(@NotNull BuildContext buildContext, @NotNull Date date) {
            super(buildContext, date);
        }
    }

    public static class AgentAssigned
    extends AbstractBuildTimingPoint {
        private final long agentId;

        public AgentAssigned(@NotNull PlanResultKey planResultKey, @NotNull Date date, long agentId) {
            super(planResultKey, date);
            this.agentId = agentId;
        }

        public long getAgentId() {
            return this.agentId;
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("date=" + String.valueOf(this.getDate())).add("planResultKey=" + String.valueOf(this.getPlanResultKey())).add("agentId=" + this.getAgentId()).toString();
        }
    }

    public static class SentToAgent
    extends AbstractBuildTimingPoint {
        private final long agentId;

        public SentToAgent(@NotNull PlanResultKey planResultKey, @NotNull Date date, long agentId) {
            super(planResultKey, date);
            this.agentId = agentId;
        }

        public long getAgentId() {
            return this.agentId;
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("date=" + String.valueOf(this.getDate())).add("planResultKey=" + String.valueOf(this.getPlanResultKey())).add("agentId=" + this.getAgentId()).toString();
        }
    }

    @Deprecated
    public static class VcsSyncStarted
    extends AbstractBuildTimingPoint {
        public VcsSyncStarted(@NotNull PlanResultKey planResultKey, @NotNull Date date) {
            super(planResultKey, date);
        }
    }

    public static class ExecutionStarted
    extends AbstractBuildTimingPoint {
        public ExecutionStarted(@NotNull PlanResultKey planResultKey, @NotNull Date date) {
            super(planResultKey, date);
        }
    }

    public static class ExecutionCancelled
    extends AbstractBuildTimingPoint {
        private final boolean buildActuallyCancelled;

        public ExecutionCancelled(@NotNull PlanResultKey planResultKey, @NotNull Date date, boolean buildActuallyCancelled) {
            super(planResultKey, date);
            this.buildActuallyCancelled = buildActuallyCancelled;
        }

        public boolean isBuildActuallyCancelled() {
            return this.buildActuallyCancelled;
        }
    }

    public static class ExecutionFinished
    extends AbstractBuildTimingPoint {
        public ExecutionFinished(@NotNull PlanResultKey planResultKey, @NotNull Date date) {
            super(planResultKey, date);
        }
    }
}

