/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.timing;

import com.atlassian.bamboo.v2.build.timing.AbstractBuildTimingPoint;
import com.atlassian.bamboo.v2.build.timing.BuildTimingPoints;
import com.atlassian.bamboo.v2.build.timing.OutOfBandTimingPoint;
import com.atlassian.bamboo.v2.build.timing.TimingPoint;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nullable;

public class OutOfBandBuildTimingPoints {
    private static final Map<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>> outOfBandTimingPointClasses = new HashMap<Class<? extends TimingPoint>, Class<? extends OutOfBandTimingPoint>>();

    @Nullable
    public static Class<? extends OutOfBandTimingPoint> getOobClassForTimingPoint(TimingPoint timingPoint) {
        return outOfBandTimingPointClasses.get(timingPoint.getClass());
    }

    static {
        outOfBandTimingPointClasses.put(BuildTimingPoints.AgentAssigned.class, AgentAssigned.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.ExecutionStarted.class, ExecutionStarted.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.VcsSyncStarted.class, VcsSyncStarted.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.ExecutionFinished.class, ExecutionFinished.class);
        outOfBandTimingPointClasses.put(BuildTimingPoints.SentToAgent.class, SentToAgent.class);
    }

    public static class AgentAssigned
    extends OutOfBandAgentAssigned {
        private AgentAssigned(BuildTimingPoints.AgentAssigned timingPoint) {
            super(timingPoint);
        }
    }

    public static class ExecutionStarted
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private ExecutionStarted(BuildTimingPoints.ExecutionStarted timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
        }
    }

    @Deprecated
    public static class VcsSyncStarted
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private VcsSyncStarted(BuildTimingPoints.VcsSyncStarted timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
        }
    }

    public static class ExecutionFinished
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private ExecutionFinished(BuildTimingPoints.ExecutionFinished timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
        }
    }

    public static class SentToAgent
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private final long agentId;

        private SentToAgent(BuildTimingPoints.SentToAgent timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
            this.agentId = timingPoint.getAgentId();
        }

        public long getAgentId() {
            return this.agentId;
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("date=" + String.valueOf(this.getDate())).add("planResultKey=" + String.valueOf(this.getPlanResultKey())).add("agentId=" + this.getAgentId()).toString();
        }
    }

    @Deprecated
    public static class OutOfBandAgentAssigned
    extends AbstractBuildTimingPoint
    implements OutOfBandTimingPoint {
        private final long agentId;

        protected OutOfBandAgentAssigned(BuildTimingPoints.AgentAssigned timingPoint) {
            super(timingPoint.getPlanResultKey(), timingPoint.getDate());
            this.agentId = timingPoint.getAgentId();
        }

        public long getAgentId() {
            return this.agentId;
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("date=" + String.valueOf(this.getDate())).add("planResultKey=" + String.valueOf(this.getPlanResultKey())).add("agentId=" + this.getAgentId()).toString();
        }
    }
}

